/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.caching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.cache.Cache;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.api.GhostResource;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class CachingHandler
extends Handler {
    private Map<String, DataBaseConfiguration> dbConfigs = new HashMap<String, DataBaseConfiguration>();
    private Map<String, DataBaseConfiguration> dbConfigsWithMounts = new HashMap<String, DataBaseConfiguration>();
    private Map<String, String> pathMap = new HashMap<String, String>();

    public CachingHandler() {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        for (Mount mount : registryContext.getMounts()) {
            for (RemoteConfiguration configuration : registryContext.getRemoteInstances()) {
                if (configuration.getDbConfig() == null || !mount.getInstanceId().equals(configuration.getId())) continue;
                this.dbConfigs.put(mount.getTargetPath(), registryContext.getDBConfig(configuration.getDbConfig()));
                this.dbConfigsWithMounts.put(mount.getPath(), registryContext.getDBConfig(configuration.getDbConfig()));
                this.pathMap.put(mount.getPath(), mount.getTargetPath());
            }
        }
    }

    private static Cache<RegistryCacheKey, GhostResource> getCache() {
        return RegistryUtils.getResourceCache("REG_CACHE_BACKED_ID");
    }

    private void clearCache(RequestContext requestContext, String cachePath, boolean recursive) {
        this.clearCache(requestContext, cachePath, recursive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(RequestContext requestContext, String cachePath, boolean recursive, boolean local) {
        int tenantId;
        String connectionId = "";
        DataBaseConfiguration dataBaseConfiguration = null;
        boolean doLocalCleanup = false;
        String cleanupPath = cachePath;
        if (!local && this.dbConfigs.size() > 0) {
            for (String targetPath : this.dbConfigs.keySet()) {
                if (!cachePath.startsWith(targetPath)) continue;
                dataBaseConfiguration = this.dbConfigs.get(targetPath);
                break;
            }
            if (dataBaseConfiguration == null) {
                for (String targetPath : this.dbConfigsWithMounts.keySet()) {
                    if (!cachePath.startsWith(targetPath)) continue;
                    dataBaseConfiguration = this.dbConfigsWithMounts.get(targetPath);
                    cleanupPath = this.pathMap.get(targetPath) + cachePath.substring(targetPath.length());
                    break;
                }
            }
        }
        if (!local && dataBaseConfiguration != null) {
            doLocalCleanup = true;
        }
        if (dataBaseConfiguration == null) {
            RegistryContext registryContext = requestContext.getRegistryContext();
            if (registryContext == null) {
                registryContext = RegistryContext.getBaseInstance();
            }
            dataBaseConfiguration = registryContext.getDefaultDataBaseConfiguration();
        }
        if (dataBaseConfiguration != null) {
            connectionId = dataBaseConfiguration.getUserName() + "@" + dataBaseConfiguration.getDbUrl();
        }
        if ((tenantId = CurrentSession.getTenantId()) == -1) {
            tenantId = CarbonContext.getCurrentContext().getTenantId();
        }
        if (local && CurrentSession.getLocalPathMap() != null && CurrentSession.getLocalPathMap().get(cachePath) != null) {
            cleanupPath = CurrentSession.getLocalPathMap().get(cachePath);
        } else if (!local && doLocalCleanup) {
            if (cachePath.equals(cleanupPath)) {
                this.clearCache(requestContext, cachePath, recursive, true);
            } else {
                if (CurrentSession.getLocalPathMap() == null) {
                    CurrentSession.setLocalPathMap(Collections.singletonMap(cleanupPath, cachePath));
                    try {
                        this.clearCache(requestContext, cleanupPath, recursive, true);
                    }
                    finally {
                        CurrentSession.removeLocalPathMap();
                    }
                }
                Map<String, String> currentLocalPathMap = CurrentSession.getLocalPathMap();
                HashMap<String, String> newLocalPathMap = new HashMap<String, String>(currentLocalPathMap);
                newLocalPathMap.put(cleanupPath, cachePath);
                CurrentSession.setLocalPathMap(newLocalPathMap);
                try {
                    this.clearCache(requestContext, cleanupPath, recursive, true);
                }
                finally {
                    CurrentSession.setLocalPathMap(currentLocalPathMap);
                }
            }
        }
        this.removeFromCache(connectionId, tenantId, cleanupPath);
        String parentPath = RegistryUtils.getParentPath(cleanupPath);
        Cache<RegistryCacheKey, GhostResource> cache = CachingHandler.getCache();
        Iterator keys = cache.keys();
        while (keys.hasNext()) {
            RegistryCacheKey key = (RegistryCacheKey)keys.next();
            String path = key.getPath();
            if (!recursive || !path.startsWith(cleanupPath)) continue;
            this.removeFromCache(connectionId, tenantId, path);
        }
        this.clearAncestry(connectionId, tenantId, parentPath);
    }

    private void clearAncestry(String connectionId, int tenantId, String parentPath) {
        boolean cleared = this.removeFromCache(connectionId, tenantId, parentPath);
        String pagedParentPathPrefix = "^" + Pattern.quote(parentPath == null ? "" : parentPath) + "(" + "/" + ")?(;start=.*)?$";
        Pattern pattern = Pattern.compile(pagedParentPathPrefix);
        Cache<RegistryCacheKey, GhostResource> cache = CachingHandler.getCache();
        Iterator keys = cache.keys();
        while (keys.hasNext()) {
            RegistryCacheKey key = (RegistryCacheKey)keys.next();
            String path = key.getPath();
            if (!pattern.matcher(path).matches()) continue;
            cleared = cleared || this.removeFromCache(connectionId, tenantId, path);
        }
        if (!cleared && parentPath != null && !parentPath.equals("/")) {
            this.clearAncestry(connectionId, tenantId, RegistryUtils.getParentPath(parentPath));
        }
    }

    private boolean removeFromCache(String connectionId, int tenantId, String path) {
        RegistryCacheKey cacheKey = RegistryUtils.buildRegistryCacheKey(connectionId, tenantId, path);
        Cache<RegistryCacheKey, GhostResource> cache = CachingHandler.getCache();
        if (cache.containsKey((Object)cacheKey)) {
            cache.remove((Object)cacheKey);
            return true;
        }
        return false;
    }

    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        String path;
        Resource resource = requestContext.getResource();
        if (resource.getProperty("registry.link") != null && (path = resource.getProperty("registry.realpath")) != null) {
            path = path.substring(path.indexOf("/resourceContent?path=") + "/resourceContent?path=".length());
            this.clearCache(requestContext, path, requestContext.getResource() instanceof Collection);
        }
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), requestContext.getResource() instanceof Collection || requestContext.getResource() instanceof GhostResource && ((GhostResource)requestContext.getResource()).getResource() instanceof Collection);
        super.put(requestContext);
    }

    @Override
    public void importResource(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), false);
        super.importResource(requestContext);
    }

    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getSourcePath(), true);
        this.clearCache(requestContext, requestContext.getTargetPath(), true);
        return super.move(requestContext);
    }

    @Override
    public String copy(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getTargetPath(), true);
        return super.copy(requestContext);
    }

    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getSourcePath(), true);
        return super.rename(requestContext);
    }

    @Override
    public void createLink(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), true);
        super.createLink(requestContext);
    }

    @Override
    public void removeLink(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), true);
        super.removeLink(requestContext);
    }

    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), true);
        super.delete(requestContext);
    }

    @Override
    public void restore(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, requestContext.getResourcePath().getPath(), true);
        super.restore(requestContext);
    }

    @Override
    public void restoreVersion(RequestContext requestContext) throws RegistryException {
        this.clearCache(requestContext, new ResourcePath(requestContext.getVersionPath()).getPath(), true);
        super.restoreVersion(requestContext);
    }
}

