/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableConduitBridge
extends ConduitBridge {
    private static final Logger LOG = LoggerFactory.getLogger(DurableConduitBridge.class);

    public String toString() {
        return "DurableConduitBridge:" + this.configuration.getBrokerName() + "->" + this.getRemoteBrokerName();
    }

    public DurableConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    @Override
    protected void setupStaticDestinations() {
        ActiveMQDestination[] dests;
        super.setupStaticDestinations();
        ActiveMQDestination[] activeMQDestinationArray = dests = this.configuration.isDynamicOnly() ? null : this.durableDestinations;
        if (dests != null) {
            for (ActiveMQDestination dest : dests) {
                if (!this.isPermissableDestination(dest) || this.doesConsumerExist(dest)) continue;
                DemandSubscription sub = this.createDemandSubscription(dest);
                sub.setStaticallyIncluded(true);
                if (dest.isTopic()) {
                    sub.getLocalInfo().setSubscriptionName(this.getSubscriberName(dest));
                }
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    LOG.error("Failed to add static destination {}", (Object)dest, (Object)e);
                }
                LOG.trace("Forwarding messages for durable destination: {}", (Object)dest);
            }
        }
    }

    @Override
    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        if (info.isDurable()) {
            info.setSubscriptionName(this.getSubscriberName(info.getDestination()));
            info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        }
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected String getSubscriberName(ActiveMQDestination dest) {
        String subscriberName = "NC-DS_" + this.configuration.getBrokerName() + "_" + dest.getPhysicalName();
        return subscriberName;
    }

    protected boolean doesConsumerExist(ActiveMQDestination dest) {
        DestinationFilter filter = DestinationFilter.parseFilter(dest);
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            return true;
        }
        return false;
    }
}

