/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteTopologyRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TopologyEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(TopologyEventReceiver.class);
    private TopologyEventMessageDelegator messageDelegator;
    private TopologyEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile TopologyEventReceiver instance;

    private TopologyEventReceiver() {
        TopologyEventMessageQueue messageQueue = new TopologyEventMessageQueue();
        this.messageDelegator = new TopologyEventMessageDelegator(messageQueue);
        this.messageListener = new TopologyEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<TopologyEventReceiver> clazz = TopologyEventReceiver.class;
        synchronized (TopologyEventReceiver.class) {
            if (instance != null) return instance;
            instance = new TopologyEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.TOPOLOGY_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message delegator thread started");
                }
                this.initializeCompleteTopology();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Topology receiver failed", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public void initializeCompleteTopology() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!TopologyEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CompleteTopologyRequestEvent completeTopologyRequestEvent = new CompleteTopologyRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeTopologyRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeTopologyRequestEvent);
            }
        });
    }
}

