/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.status;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InstanceStatusEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(InstanceStatusEventReceiver.class);
    private final InstanceStatusEventMessageDelegator messageDelegator;
    private final InstanceStatusEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile InstanceStatusEventReceiver instance;

    private InstanceStatusEventReceiver() {
        InstanceStatusEventMessageQueue messageQueue = new InstanceStatusEventMessageQueue();
        this.messageDelegator = new InstanceStatusEventMessageDelegator(messageQueue);
        this.messageListener = new InstanceStatusEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstanceStatusEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<InstanceStatusEventReceiver> clazz = InstanceStatusEventReceiver.class;
        synchronized (InstanceStatusEventReceiver.class) {
            if (instance != null) return instance;
            instance = new InstanceStatusEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INSTANCE_STATUS_TOPIC.getTopicName(), this.messageListener);
                this.executor.submit(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                this.executor.submit(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

