/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.domain.mapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageListener;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class DomainMappingEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(DomainMappingEventReceiver.class);
    private DomainMappingEventMessageDelegator messageDelegator;
    private DomainMappingEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile DomainMappingEventReceiver instance;

    private DomainMappingEventReceiver() {
        DomainMappingEventMessageQueue messageQueue = new DomainMappingEventMessageQueue();
        this.messageDelegator = new DomainMappingEventMessageDelegator(messageQueue);
        this.messageListener = new DomainMappingEventMessageListener(messageQueue);
        this.execute();
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainMappingEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<DomainMappingEventReceiver> clazz = DomainMappingEventReceiver.class;
        synchronized (DomainMappingEventReceiver.class) {
            if (instance != null) return instance;
            instance = new DomainMappingEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.DOMAIN_MAPPING_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Domain mapping event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Domain mapping event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Domain mapping receiver failed", (Throwable)e);
            }
        }
    }
}

