/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application.signup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.application.signup.ApplicationSignUpMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageQueue;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpManager;

class ApplicationSignUpEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(ApplicationSignUpEventMessageDelegator.class);
    private MessageProcessorChain processorChain;
    private ApplicationSignUpEventMessageQueue messageQueue;
    private boolean terminated;

    public ApplicationSignUpEventMessageDelegator(ApplicationSignUpEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new ApplicationSignUpMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.processorChain.removeEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Application signup event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Application signup event message received from queue: [event-class-name] %s [message-queue] %s", type, this.messageQueue.getClass()));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating application signup event message: %s", type));
                        }
                        this.processorChain.process(type, json, ApplicationSignUpManager.getInstance());
                    }
                    catch (InterruptedException e) {
                        log.info((Object)"Application signup event message delegator is shutting down...");
                        return;
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve application signup event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Application signup event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

