/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.messaging.listener.EventListener;

public abstract class StratosEventReceiver {
    protected ThreadPoolExecutor executor;
    private static final Log log = LogFactory.getLog(StratosEventReceiver.class);
    public static String STRATOS_EVENT_RECEIEVER_THREAD_POOL_ID = "stratos-event-receiver-pool";
    private static String STRATOS_EVENT_RECEIEVER_THREAD_POOL_SIZE = "stratos.event.receiver.pool.size";
    protected String threadPoolId = STRATOS_EVENT_RECEIEVER_THREAD_POOL_ID;
    protected static int threadPoolSize = 25;

    public StratosEventReceiver() {
        Integer ratio = Integer.getInteger("thread.pool.initial.min.max.ratio");
        int divisor = ratio != null && ratio >= 1 ? ratio : 3;
        this.executor = StratosThreadPool.getExecutorService((String)this.threadPoolId, (int)((int)Math.ceil(threadPoolSize / divisor)), (int)threadPoolSize);
    }

    public abstract void addEventListener(EventListener var1);

    public abstract void removeEventListener(EventListener var1);

    public abstract void terminate();

    static {
        String poolSize = System.getProperty(STRATOS_EVENT_RECEIEVER_THREAD_POOL_SIZE);
        if (poolSize != null) {
            try {
                threadPoolSize = Integer.parseInt(poolSize);
            }
            catch (NumberFormatException e) {
                log.error((Object)"Invalid configuration found for StratosEventReceiver thread pool size", (Throwable)e);
                threadPoolSize = 25;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of threads used in pool " + STRATOS_EVENT_RECEIEVER_THREAD_POOL_ID + " : " + threadPoolSize));
        }
    }
}

