/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.instance.ClusterInstance;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.ClusterStatus;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterInstanceActivatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterInstanceActivatedProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterInstanceActivatedProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterInstanceActivatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterInstanceActivatedEvent event = (ClusterInstanceActivatedEvent)MessagingUtil.jsonToObject(message, ClusterInstanceActivatedEvent.class);
            String clusterId = event.getClusterId();
            TopologyUpdater.acquireWriteLockForCluster(event.getServiceName(), clusterId);
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForCluster(event.getServiceName(), clusterId);
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ClusterInstanceActivatedEvent event, Topology topology) {
        String applicationId = event.getAppId();
        String serviceName = event.getServiceName();
        String clusterId = event.getClusterId();
        if (TopologyApplicationFilter.apply(applicationId)) {
            return false;
        }
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (TopologyClusterFilter.apply(clusterId)) {
            return false;
        }
        Service service = topology.getService(event.getServiceName());
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
            }
            return false;
        }
        Cluster cluster = service.getCluster(event.getClusterId());
        if (cluster == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cluster not exists in service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                return false;
            }
        } else {
            ClusterInstance clusterInstance = cluster.getInstanceContexts(event.getInstanceId());
            if (clusterInstance == null) {
                log.warn((Object)String.format("Cluster instance not found: [application] %s [cluster] %s [instance-id] %s", event.getAppId(), event.getClusterId(), event.getInstanceId()));
                return false;
            }
            if (clusterInstance.getStatus() == ClusterStatus.Active) {
                log.debug((Object)String.format("Cluster instance is already activated, event ignored: [application] %s [cluster] %s [instance-id] %s", event.getAppId(), event.getClusterId(), event.getInstanceId()));
            } else {
                ClusterStatus status;
                cluster.addAccessUrlList(event.getInstanceId(), event.getAccessUrls());
                if (event.getLoadBalancerIps() != null && event.getLoadBalancerIps().size() > 0) {
                    cluster.setLoadBalancerIps(event.getLoadBalancerIps());
                }
                if (!clusterInstance.isStateTransitionValid(status = ClusterStatus.Active)) {
                    log.error((Object)("Invalid state transition from " + clusterInstance.getStatus() + " to " + status));
                }
                clusterInstance.setStatus(status);
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

