/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ApplicationClustersRemovedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationClustersRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationClustersRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ApplicationClustersRemovedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ApplicationClustersRemovedEvent event = (ApplicationClustersRemovedEvent)MessagingUtil.jsonToObject(message, ApplicationClustersRemovedEvent.class);
            return this.doProcess(event, topology);
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcess(ApplicationClustersRemovedEvent event, Topology topology) {
        Set<ClusterDataHolder> clusterData = event.getClusterData();
        if (clusterData != null) {
            for (ClusterDataHolder aClusterData : clusterData) {
                String serviceType = aClusterData.getServiceType();
                TopologyUpdater.acquireWriteLockForService(serviceType);
                try {
                    Service aService = topology.getService(serviceType);
                    if (aService != null) {
                        if (aService.clusterExists(aClusterData.getClusterId())) {
                            aService.removeCluster(aClusterData.getClusterId());
                            log.info((Object)("Cluster " + aClusterData.getClusterId() + " removed from topology for application " + event.getAppId()));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Cluster " + aClusterData.getClusterId() + " of application " + event.getAppId() + " already removed from topology"));
                        continue;
                    }
                    log.warn((Object)("Service " + serviceType + " not found, unable to remove Cluster " + aClusterData.getClusterId()));
                }
                finally {
                    TopologyUpdater.releaseWriteLockForService(serviceType);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No cluster data found in application " + event.getAppId() + " to remove from Topology"));
        }
        this.notifyEventListeners(event);
        return true;
    }
}

