/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application.updater;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLock;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLockHierarchy;

public class ApplicationsUpdater {
    private static final Log log = LogFactory.getLog(ApplicationsUpdater.class);
    private static volatile ApplicationLockHierarchy applicationLockHierarchy = ApplicationLockHierarchy.getInstance();

    public static void acquireWriteLockForApplications() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired for Applications");
        }
        applicationLockHierarchy.getApplicationLock().acquireWriteLock();
    }

    public static void releaseWriteLockForApplications() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released for Applications");
        }
        applicationLockHierarchy.getApplicationLock().releaseWriteLock();
    }

    public static void acquireWriteLockForApplication(String appId) {
        ApplicationLock applicationLock = applicationLockHierarchy.getLockForApplication(appId);
        applicationLock.acquireWriteLock();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Write lock acquired for Application " + appId));
        }
    }

    public static void releaseWriteLockForApplication(String appId) {
        ApplicationLock applicationLock = applicationLockHierarchy.getLockForApplication(appId);
        applicationLock.releaseWriteLock();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Write lock released for application: [application-id] " + appId));
        }
    }
}

