/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.subscribe;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.RetryTimer;
import org.apache.stratos.messaging.broker.connect.TopicSubscriber;
import org.apache.stratos.messaging.broker.connect.TopicSubscriberFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.util.MessagingUtil;
import org.eclipse.paho.client.mqttv3.MqttException;

public class EventSubscriber
implements Runnable {
    private static final Log log = LogFactory.getLog(EventSubscriber.class);
    private final TopicSubscriber topicSubscriber;
    private final String topicName;
    private boolean subscribed;

    public EventSubscriber(String topicName, MessageListener messageListener) {
        this.topicName = topicName;
        String protocol = MessagingUtil.getMessagingProtocol();
        this.topicSubscriber = TopicSubscriberFactory.createTopicSubscriber(protocol, messageListener, topicName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic subscriber created: [protocol] %s [topic] %s", protocol, topicName));
        }
    }

    private void doSubscribe() throws MqttException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Subscribing to topic: [topic] %s [server] %s", this.topicName, this.topicSubscriber.getServerURI()));
        }
        this.topicSubscriber.connect();
        this.topicSubscriber.subscribe();
        this.subscribed = true;
    }

    @Override
    public void run() {
        RetryTimer retryTimer = new RetryTimer();
        while (!this.subscribed) {
            try {
                this.doSubscribe();
            }
            catch (Exception e) {
                this.subscribed = false;
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error while subscribing to topic: " + this.topicName), (Throwable)e);
                }
                long interval = retryTimer.getNextInterval();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will try to subscribe again in " + interval / 1000L + " sec"));
                }
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void terminate() {
        if (this.topicSubscriber != null) {
            this.topicSubscriber.disconnect();
        }
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }
}

