/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.needle.terracotta.TerracottaDirectory;

public class TerracottaDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    public static final String PROTOCOL = "tc://";
    public static final String BUFFER_SIZE_PROP = "compass.engine.store.tc.bufferSize";
    public static final String FLUSH_RATE_PROP = "compass.engine.store.tc.flushRate";
    private final Map<String, Map<String, Map<String, TerracottaDirectory>>> dirs = new HashMap<String, Map<String, Map<String, TerracottaDirectory>>>();
    private int bufferSize;
    private int flushRate;
    private transient String indexName;

    public void configure(CompassSettings settings) throws CompassException {
        this.indexName = settings.getSetting("compass.engine.connection").substring(PROTOCOL.length());
        this.bufferSize = settings.getSettingAsInt(BUFFER_SIZE_PROP, 4096);
        this.flushRate = settings.getSettingAsInt(FLUSH_RATE_PROP, 10);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Terracotta directory store configured with index [" + this.indexName + "], bufferSize [" + this.bufferSize + "], and flushRate [" + this.flushRate + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        Map<String, Map<String, Map<String, TerracottaDirectory>>> map = this.dirs;
        synchronized (map) {
            TerracottaDirectory dir;
            Map<String, TerracottaDirectory> subIndexDirs;
            Map<String, Map<String, TerracottaDirectory>> index = this.dirs.get(this.indexName);
            if (index == null) {
                index = new HashMap<String, Map<String, TerracottaDirectory>>();
                this.dirs.put(this.indexName, index);
            }
            if ((subIndexDirs = index.get(subContext)) == null) {
                subIndexDirs = new HashMap<String, TerracottaDirectory>();
                index.put(subContext, subIndexDirs);
            }
            if ((dir = subIndexDirs.get(subIndex)) == null) {
                dir = new TerracottaDirectory(this.bufferSize, this.flushRate);
                subIndexDirs.put(subIndex, dir);
            }
            return dir;
        }
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.deleteIndex(dir, subContext, subIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        Map<String, Map<String, Map<String, TerracottaDirectory>>> map = this.dirs;
        synchronized (map) {
            Map<String, Map<String, TerracottaDirectory>> index = this.dirs.get(this.indexName);
            if (index == null) {
                return;
            }
            Map<String, TerracottaDirectory> subIndexDirs = index.get(subContext);
            if (subIndexDirs != null) {
                subIndexDirs.remove(subIndex);
            }
        }
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            String[] files;
            for (String file : files = dir.list()) {
                dir.deleteFile(file);
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Faield to delete ram directory before copy", e);
        }
        return new CopyFromHolder();
    }

    public String suggestedIndexDeletionPolicy() {
        return "expirationtime";
    }
}

