/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQUndeliveredException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQNoConsumersException;
import org.wso2.andes.client.AMQNoRouteException;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageConsumer_0_8;
import org.wso2.andes.client.BasicMessageProducer_0_8;
import org.wso2.andes.client.JMSAMQException;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.client.failover.FailoverProtectedOperation;
import org.wso2.andes.client.failover.FailoverRetrySupport;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.client.message.MessageFactoryRegistry;
import org.wso2.andes.client.message.ReturnMessage;
import org.wso2.andes.client.message.UnprocessedMessage;
import org.wso2.andes.client.protocol.AMQProtocolHandler;
import org.wso2.andes.client.state.AMQState;
import org.wso2.andes.client.state.AMQStateManager;
import org.wso2.andes.client.state.listener.SpecificMethodFrameListener;
import org.wso2.andes.common.AMQPFilterTypes;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicAckBody;
import org.wso2.andes.framing.BasicConsumeBody;
import org.wso2.andes.framing.BasicConsumeOkBody;
import org.wso2.andes.framing.BasicQosBody;
import org.wso2.andes.framing.BasicQosOkBody;
import org.wso2.andes.framing.BasicRecoverBody;
import org.wso2.andes.framing.BasicRecoverOkBody;
import org.wso2.andes.framing.BasicRecoverSyncBody;
import org.wso2.andes.framing.BasicRecoverSyncOkBody;
import org.wso2.andes.framing.BasicRejectBody;
import org.wso2.andes.framing.ChannelCloseOkBody;
import org.wso2.andes.framing.ChannelFlowBody;
import org.wso2.andes.framing.ChannelFlowOkBody;
import org.wso2.andes.framing.ExchangeBoundOkBody;
import org.wso2.andes.framing.ExchangeDeclareBody;
import org.wso2.andes.framing.ExchangeDeclareOkBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.FieldTableFactory;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.framing.QueueBindOkBody;
import org.wso2.andes.framing.QueueDeclareBody;
import org.wso2.andes.framing.QueueDeclareOkBody;
import org.wso2.andes.framing.QueueDeleteBody;
import org.wso2.andes.framing.QueueDeleteOkBody;
import org.wso2.andes.framing.TxCommitOkBody;
import org.wso2.andes.framing.TxRollbackBody;
import org.wso2.andes.framing.TxRollbackOkBody;
import org.wso2.andes.framing.amqp_0_9.MethodRegistry_0_9;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.protocol.AMQMethodEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMQSession_0_8
extends AMQSession<BasicMessageConsumer_0_8, BasicMessageProducer_0_8> {
    private static final Logger _logger = LoggerFactory.getLogger(AMQSession.class);

    AMQSession_0_8(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, MessageFactoryRegistry messageFactoryRegistry, int defaultPrefetchHighMark, int defaultPrefetchLowMark) {
        super(con, channelId, transacted, acknowledgeMode, messageFactoryRegistry, defaultPrefetchHighMark, defaultPrefetchLowMark);
    }

    AMQSession_0_8(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, int defaultPrefetchHigh, int defaultPrefetchLow) {
        this(con, channelId, transacted, acknowledgeMode, MessageFactoryRegistry.newDefaultRegistry(), defaultPrefetchHigh, defaultPrefetchLow);
    }

    private ProtocolVersion getProtocolVersion() {
        return this.getProtocolHandler().getProtocolVersion();
    }

    @Override
    public void acknowledgeMessage(long deliveryTag, boolean multiple) {
        BasicAckBody body = this.getMethodRegistry().createBasicAckBody(deliveryTag, multiple);
        AMQFrame ackFrame = body.generateFrame(this._channelId);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending ack for delivery tag " + deliveryTag + " on channel " + this._channelId);
        }
        this.getProtocolHandler().writeFrame(ackFrame);
        this._unacknowledgedMessageTags.remove(deliveryTag);
    }

    @Override
    public void sendQueueBind(AMQShortString queueName, AMQShortString routingKey, FieldTable arguments, AMQShortString exchangeName, AMQDestination dest, boolean nowait) throws AMQException, FailoverException {
        this.getProtocolHandler().syncWrite(this.getProtocolHandler().getMethodRegistry().createQueueBindBody(this.getTicket(), queueName, exchangeName, routingKey, false, arguments).generateFrame(this._channelId), QueueBindOkBody.class);
    }

    @Override
    public void sendClose(long timeout) throws AMQException, FailoverException {
        if (!this.getProtocolHandler().getStateManager().getCurrentState().equals((Object)AMQState.CONNECTION_CLOSED) && !this.getProtocolHandler().getStateManager().getCurrentState().equals((Object)AMQState.CONNECTION_CLOSING)) {
            this.getProtocolHandler().closeSession(this);
            this.getProtocolHandler().syncWrite(this.getProtocolHandler().getMethodRegistry().createChannelCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), new AMQShortString("JMS client closing channel"), 0, 0).generateFrame(this._channelId), ChannelCloseOkBody.class, timeout);
        }
    }

    @Override
    public void sendCommit() throws AMQException, FailoverException {
        AMQProtocolHandler handler = this.getProtocolHandler();
        handler.syncWrite(this.getProtocolHandler().getMethodRegistry().createTxCommitBody().generateFrame(this._channelId), TxCommitOkBody.class);
    }

    @Override
    public void sendCreateQueue(AMQShortString name, boolean autoDelete, boolean durable, boolean exclusive, Map<String, Object> arguments) throws AMQException, FailoverException {
        FieldTable table = null;
        if (arguments != null && !arguments.isEmpty()) {
            table = new FieldTable();
            for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                table.setObject(entry.getKey(), entry.getValue());
            }
        }
        QueueDeclareBody body = this.getMethodRegistry().createQueueDeclareBody(this.getTicket(), name, false, durable, exclusive, autoDelete, false, table);
        AMQFrame queueDeclare = body.generateFrame(this._channelId);
        this.getProtocolHandler().syncWrite(queueDeclare, QueueDeclareOkBody.class);
    }

    @Override
    public void sendRecover() throws AMQException, FailoverException {
        this._unacknowledgedMessageTags.clear();
        if (this.isStrictAMQP()) {
            BasicRecoverBody body = this.getMethodRegistry().createBasicRecoverBody(false);
            this._connection.getProtocolHandler().writeFrame(body.generateFrame(this._channelId));
            _logger.warn("Session Recover cannot be guaranteed with STRICT_AMQP. Messages may arrive out of order.");
        } else if (this.getProtocolHandler().getProtocolVersion().equals(ProtocolVersion.v8_0)) {
            BasicRecoverBody body = this.getMethodRegistry().createBasicRecoverBody(false);
            this._connection.getProtocolHandler().syncWrite(body.generateFrame(this._channelId), BasicRecoverOkBody.class);
        } else if (this.getProtocolVersion().equals(ProtocolVersion.v0_9)) {
            BasicRecoverSyncBody body = ((MethodRegistry_0_9)this.getMethodRegistry()).createBasicRecoverSyncBody(false);
            this._connection.getProtocolHandler().syncWrite(body.generateFrame(this._channelId), BasicRecoverSyncOkBody.class);
        } else if (this.getProtocolVersion().equals(ProtocolVersion.v0_91)) {
            BasicRecoverSyncBody body = ((MethodRegistry_0_91)this.getMethodRegistry()).createBasicRecoverSyncBody(false);
            this._connection.getProtocolHandler().syncWrite(body.generateFrame(this._channelId), BasicRecoverSyncOkBody.class);
        } else {
            throw new RuntimeException("Unsupported version of the AMQP Protocol: " + this.getProtocolVersion());
        }
    }

    @Override
    public void releaseForRollback() {
        Long tag;
        while ((tag = (Long)this._deliveredMessageTags.poll()) != null) {
            this.rejectMessage(tag, true);
        }
    }

    @Override
    public void rejectMessage(long deliveryTag, boolean requeue) {
        if (this._acknowledgeMode == 2 || this._acknowledgeMode == 0) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Rejecting delivery tag:" + deliveryTag + ":SessionHC:" + this.hashCode());
            }
            BasicRejectBody body = this.getMethodRegistry().createBasicRejectBody(deliveryTag, requeue);
            AMQFrame frame = body.generateFrame(this._channelId);
            this._connection.getProtocolHandler().writeFrame(frame);
        }
    }

    @Override
    public boolean isQueueBound(AMQDestination destination) throws JMSException {
        return this.isQueueBound(destination.getExchangeName(), destination.getAMQQueueName(), destination.getAMQQueueName());
    }

    @Override
    public boolean isQueueBound(final AMQShortString exchangeName, final AMQShortString queueName, final AMQShortString routingKey) throws JMSException {
        try {
            AMQMethodEvent response = new FailoverRetrySupport<AMQMethodEvent, AMQException>(new FailoverProtectedOperation<AMQMethodEvent, AMQException>(){

                @Override
                public AMQMethodEvent execute() throws AMQException, FailoverException {
                    AMQFrame boundFrame = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry().createExchangeBoundBody(exchangeName, routingKey, queueName).generateFrame(AMQSession_0_8.this._channelId);
                    return AMQSession_0_8.this.getProtocolHandler().syncWrite(boundFrame, ExchangeBoundOkBody.class);
                }
            }, this._connection).execute();
            ExchangeBoundOkBody responseBody = (ExchangeBoundOkBody)response.getMethod();
            return responseBody.getReplyCode() == 0;
        }
        catch (AMQException e) {
            throw new JMSAMQException("Queue bound query failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void sendConsume(BasicMessageConsumer_0_8 consumer, AMQShortString queueName, AMQProtocolHandler protocolHandler, boolean nowait, String messageSelector, int tag) throws AMQException, FailoverException {
        FieldTable arguments = FieldTableFactory.newFieldTable();
        if (messageSelector != null && !messageSelector.equals("")) {
            arguments.put(AMQPFilterTypes.JMS_SELECTOR.getValue(), messageSelector);
        }
        if (consumer.isAutoClose()) {
            arguments.put(AMQPFilterTypes.AUTO_CLOSE.getValue(), Boolean.TRUE);
        }
        if (consumer.isNoConsume()) {
            arguments.put(AMQPFilterTypes.NO_CONSUME.getValue(), Boolean.TRUE);
        }
        BasicConsumeBody body = this.getMethodRegistry().createBasicConsumeBody(this.getTicket(), queueName, new AMQShortString(String.valueOf(tag)), consumer.isNoLocal(), consumer.getAcknowledgeMode() == 257, consumer.isExclusive(), nowait, arguments);
        AMQFrame jmsConsume = body.generateFrame(this._channelId);
        if (nowait) {
            protocolHandler.writeFrame(jmsConsume);
        } else {
            protocolHandler.syncWrite(jmsConsume, BasicConsumeOkBody.class);
        }
    }

    @Override
    public void sendExchangeDeclare(AMQShortString name, AMQShortString type, AMQProtocolHandler protocolHandler, boolean nowait) throws AMQException, FailoverException {
        ExchangeDeclareBody body = this.getMethodRegistry().createExchangeDeclareBody(this.getTicket(), name, type, name.toString().startsWith("amq."), false, false, false, false, null);
        AMQFrame exchangeDeclare = body.generateFrame(this._channelId);
        protocolHandler.syncWrite(exchangeDeclare, ExchangeDeclareOkBody.class);
    }

    @Override
    public void sendQueueDeclare(AMQDestination amqd, AMQProtocolHandler protocolHandler, boolean nowait) throws AMQException, FailoverException {
        QueueDeclareBody body = this.getMethodRegistry().createQueueDeclareBody(this.getTicket(), amqd.getAMQQueueName(), false, amqd.isDurable(), amqd.isExclusive(), amqd.isAutoDelete(), false, null);
        AMQFrame queueDeclare = body.generateFrame(this._channelId);
        protocolHandler.syncWrite(queueDeclare, QueueDeclareOkBody.class);
    }

    @Override
    public void sendQueueDelete(AMQShortString queueName) throws AMQException, FailoverException {
        QueueDeleteBody body = this.getMethodRegistry().createQueueDeleteBody(this.getTicket(), queueName, false, false, true);
        AMQFrame queueDeleteFrame = body.generateFrame(this._channelId);
        this.getProtocolHandler().syncWrite(queueDeleteFrame, QueueDeleteOkBody.class);
    }

    @Override
    public void sendSuspendChannel(boolean suspend) throws AMQException, FailoverException {
        ChannelFlowBody body = this.getMethodRegistry().createChannelFlowBody(!suspend);
        AMQFrame channelFlowFrame = body.generateFrame(this._channelId);
        this._connection.getProtocolHandler().syncWrite(channelFlowFrame, ChannelFlowOkBody.class);
    }

    @Override
    public BasicMessageConsumer_0_8 createMessageConsumer(AMQDestination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String messageSelector, FieldTable arguments, boolean noConsume, boolean autoClose) throws JMSException {
        AMQProtocolHandler protocolHandler = this.getProtocolHandler();
        return new BasicMessageConsumer_0_8(this._channelId, this._connection, destination, messageSelector, noLocal, this._messageFactoryRegistry, this, protocolHandler, arguments, prefetchHigh, prefetchLow, exclusive, this._acknowledgeMode, noConsume, autoClose);
    }

    @Override
    public BasicMessageProducer_0_8 createMessageProducer(Destination destination, boolean mandatory, boolean immediate, boolean waitUntilSent, long producerId) throws JMSException {
        try {
            return new BasicMessageProducer_0_8(this._connection, (AMQDestination)destination, this._transacted, this._channelId, this, this.getProtocolHandler(), producerId, immediate, mandatory, waitUntilSent);
        }
        catch (AMQException e) {
            JMSException ex = new JMSException("Error creating producer");
            ex.initCause((Throwable)e);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }

    @Override
    public void messageReceived(UnprocessedMessage message) {
        if (message instanceof ReturnMessage) {
            this.returnBouncedMessage((ReturnMessage)message);
        } else {
            super.messageReceived(message);
        }
    }

    private void returnBouncedMessage(final ReturnMessage msg) {
        this._connection.performConnectionTask(new Runnable(){

            public void run() {
                try {
                    AbstractJMSMessage bouncedMessage = AMQSession_0_8.this._messageFactoryRegistry.createMessage(0L, false, msg.getExchange(), msg.getRoutingKey(), msg.getContentHeader(), msg.getBodies());
                    AMQConstant errorCode = AMQConstant.getConstant(msg.getReplyCode());
                    AMQShortString reason = msg.getReplyText();
                    _logger.debug("Message returned with error code " + errorCode + " (" + reason + ")");
                    if (errorCode == AMQConstant.NO_CONSUMERS) {
                        AMQSession_0_8.this._connection.exceptionReceived(new AMQNoConsumersException("Error: " + reason, bouncedMessage, null));
                    } else if (errorCode == AMQConstant.NO_ROUTE) {
                        AMQSession_0_8.this._connection.exceptionReceived(new AMQNoRouteException("Error: " + reason, bouncedMessage, null));
                    } else {
                        AMQSession_0_8.this._connection.exceptionReceived(new AMQUndeliveredException(errorCode, "Error: " + reason, bouncedMessage, null));
                    }
                }
                catch (Exception e) {
                    _logger.error("Caught exception trying to raise undelivered message exception (dump follows) - ignoring...", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void sendRollback() throws AMQException, FailoverException {
        TxRollbackBody body = this.getMethodRegistry().createTxRollbackBody();
        AMQFrame frame = body.generateFrame(this.getChannelId());
        this.getProtocolHandler().syncWrite(frame, TxRollbackOkBody.class);
    }

    public void setPrefetchLimits(final int messagePrefetch, final long sizePrefetch) throws AMQException {
        new FailoverRetrySupport<Object, AMQException>(new FailoverProtectedOperation<Object, AMQException>(){

            @Override
            public Object execute() throws AMQException, FailoverException {
                BasicQosBody basicQosBody = AMQSession_0_8.this.getProtocolHandler().getMethodRegistry().createBasicQosBody(sizePrefetch, messagePrefetch, false);
                AMQSession_0_8.this.getProtocolHandler().syncWrite(basicQosBody.generateFrame(AMQSession_0_8.this.getChannelId()), BasicQosOkBody.class);
                return null;
            }
        }, this._connection).execute();
    }

    @Override
    protected Long requestQueueDepth(AMQDestination amqd) throws AMQException, FailoverException {
        AMQFrame queueDeclare = this.getMethodRegistry().createQueueDeclareBody(this.getTicket(), amqd.getAMQQueueName(), true, amqd.isDurable(), amqd.isExclusive(), amqd.isAutoDelete(), false, null).generateFrame(this._channelId);
        QueueDeclareOkHandler okHandler = new QueueDeclareOkHandler();
        this.getProtocolHandler().writeCommandFrameAndWaitForReply(queueDeclare, okHandler);
        return okHandler._messageCount;
    }

    @Override
    protected final boolean tagLE(long tag1, long tag2) {
        return tag1 <= tag2;
    }

    @Override
    protected final boolean updateRollbackMark(long currentMark, long deliveryTag) {
        return false;
    }

    @Override
    public AMQMessageDelegateFactory getMessageDelegateFactory() {
        return AMQMessageDelegateFactory.FACTORY_0_8;
    }

    @Override
    public void sync() throws AMQException {
        this.declareExchange(new AMQShortString("amq.direct"), new AMQShortString("direct"), false);
    }

    @Override
    public void handleAddressBasedDestination(AMQDestination dest, boolean isConsumer, boolean noWait) throws AMQException {
        throw new UnsupportedOperationException("The new addressing based sytanx is not supported for AMQP 0-8/0-9 versions");
    }

    @Override
    protected void flushAcknowledgments() {
    }

    @Override
    public boolean isQueueBound(String exchangeName, String queueName, String bindingKey, Map<String, Object> args) throws JMSException {
        return this.isQueueBound(exchangeName == null ? null : new AMQShortString(exchangeName), queueName == null ? null : new AMQShortString(queueName), bindingKey == null ? null : new AMQShortString(bindingKey));
    }

    @Override
    public AMQException getLastException() {
        AMQStateManager manager = this._connection.getProtocolHandler().getStateManager();
        Exception e = manager.getLastException();
        if (manager.getCurrentState().equals((Object)AMQState.CONNECTION_CLOSED) && e != null) {
            if (e instanceof AMQException) {
                return (AMQException)e;
            }
            AMQException amqe = new AMQException(AMQConstant.getConstant(AMQConstant.INTERNAL_ERROR.getCode()), e.getMessage(), e.getCause());
            return amqe;
        }
        return null;
    }

    class QueueDeclareOkHandler
    extends SpecificMethodFrameListener {
        private long _messageCount;
        private long _consumerCount;

        public QueueDeclareOkHandler() {
            super(AMQSession_0_8.this.getChannelId(), QueueDeclareOkBody.class);
        }

        public boolean processMethod(int channelId, AMQMethodBody frame) {
            boolean matches = super.processMethod(channelId, frame);
            if (matches) {
                QueueDeclareOkBody declareOk = (QueueDeclareOkBody)frame;
                this._messageCount = declareOk.getMessageCount();
                this._consumerCount = declareOk.getConsumerCount();
            }
            return matches;
        }
    }
}

