/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.event.receivers;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.domain.LoadBalancingIPType;
import org.apache.stratos.load.balancer.common.domain.Member;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.MemberStatus;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.topology.ClusterRemovedEvent;
import org.apache.stratos.messaging.event.topology.MemberActivatedEvent;
import org.apache.stratos.messaging.event.topology.MemberMaintenanceModeEvent;
import org.apache.stratos.messaging.event.topology.MemberSuspendedEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.event.topology.ServiceRemovedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.ClusterRemovedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberMaintenanceListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.listener.topology.ServiceRemovedEventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class LoadBalancerCommonTopologyEventReceiver {
    private static final Log log = LogFactory.getLog(LoadBalancerCommonTopologyEventReceiver.class);
    private TopologyProvider topologyProvider;
    private boolean initialized;
    private TopologyEventReceiver topologyEventReceiver;

    public LoadBalancerCommonTopologyEventReceiver(TopologyProvider topologyProvider) {
        this.topologyProvider = topologyProvider;
        this.topologyEventReceiver = TopologyEventReceiver.getInstance();
        this.addEventListeners();
    }

    public LoadBalancerCommonTopologyEventReceiver(TopologyProvider topologyProvider, boolean addListeners) {
        this.topologyProvider = topologyProvider;
        if (addListeners) {
            this.addEventListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTopology() {
        if (this.initialized) {
            return;
        }
        try {
            boolean membersFound = false;
            TopologyManager.acquireReadLock();
            for (org.apache.stratos.messaging.domain.topology.Service service : TopologyManager.getTopology().getServices()) {
                for (Cluster cluster : service.getClusters()) {
                    for (org.apache.stratos.messaging.domain.topology.Member member : cluster.getMembers()) {
                        if (member.getStatus() != MemberStatus.Active) continue;
                        String serviceName = member.getServiceName();
                        String clusterId = member.getClusterId();
                        String memberId = member.getMemberId();
                        String networkPartitionIdFilter = System.getProperty("stratos.topology.network.partition.filter");
                        if (networkPartitionIdFilter != null && !networkPartitionIdFilter.equals("")) {
                            if (!member.getNetworkPartitionId().equals(networkPartitionIdFilter)) continue;
                            this.addMember(serviceName, clusterId, memberId);
                            membersFound = true;
                            continue;
                        }
                        this.addMember(serviceName, clusterId, memberId);
                        membersFound = true;
                    }
                }
            }
            if (membersFound) {
                this.initialized = true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error processing complete topology event", (Throwable)e);
        }
        finally {
            TopologyManager.releaseReadLock();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addEventListeners() {
        this.topologyEventReceiver.addEventListener((EventListener)new CompleteTopologyEventListener(){

            protected void onEvent(Event event) {
                if (!LoadBalancerCommonTopologyEventReceiver.this.initialized) {
                    LoadBalancerCommonTopologyEventReceiver.this.initializeTopology();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberActivatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                MemberActivatedEvent memberActivatedEvent = (MemberActivatedEvent)event;
                String serviceName = memberActivatedEvent.getServiceName();
                String clusterId = memberActivatedEvent.getClusterId();
                String memberId = memberActivatedEvent.getMemberId();
                try {
                    TopologyManager.acquireReadLockForCluster((String)serviceName, (String)clusterId);
                    String networkPartitionIdFilter = System.getProperty("stratos.topology.network.partition.filter");
                    if (networkPartitionIdFilter != null && !networkPartitionIdFilter.equals("")) {
                        if (memberActivatedEvent.getNetworkPartitionId().equals(networkPartitionIdFilter)) {
                            LoadBalancerCommonTopologyEventReceiver.this.addMember(serviceName, clusterId, memberId);
                        } else {
                            log.debug((Object)String.format("Member exists in a different network partition.[member id] %s [member network partition] %s [filter network partition] %s ", memberId, memberActivatedEvent.getNetworkPartitionId(), networkPartitionIdFilter));
                        }
                    } else {
                        LoadBalancerCommonTopologyEventReceiver.this.addMember(serviceName, clusterId, memberId);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForCluster((String)serviceName, (String)clusterId);
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberMaintenanceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                MemberMaintenanceModeEvent memberMaintenanceModeEvent = (MemberMaintenanceModeEvent)event;
                String serviceName = memberMaintenanceModeEvent.getServiceName();
                String clusterId = memberMaintenanceModeEvent.getClusterId();
                String memberId = memberMaintenanceModeEvent.getMemberId();
                try {
                    TopologyManager.acquireReadLockForCluster((String)serviceName, (String)clusterId);
                    LoadBalancerCommonTopologyEventReceiver.this.removeMember(serviceName, clusterId, memberId);
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForCluster((String)serviceName, (String)clusterId);
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberSuspendedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                MemberSuspendedEvent memberSuspendedEvent = (MemberSuspendedEvent)event;
                String serviceName = memberSuspendedEvent.getServiceName();
                String clusterId = memberSuspendedEvent.getClusterId();
                String memberId = memberSuspendedEvent.getMemberId();
                try {
                    TopologyManager.acquireReadLockForCluster((String)serviceName, (String)clusterId);
                    LoadBalancerCommonTopologyEventReceiver.this.removeMember(serviceName, clusterId, memberId);
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForCluster((String)memberSuspendedEvent.getServiceName(), (String)memberSuspendedEvent.getClusterId());
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                MemberTerminatedEvent memberTerminatedEvent = (MemberTerminatedEvent)event;
                String serviceName = memberTerminatedEvent.getServiceName();
                String clusterId = memberTerminatedEvent.getClusterId();
                String memberId = memberTerminatedEvent.getMemberId();
                try {
                    TopologyManager.acquireReadLockForCluster((String)serviceName, (String)clusterId);
                    LoadBalancerCommonTopologyEventReceiver.this.removeMember(serviceName, clusterId, memberId);
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForCluster((String)serviceName, (String)clusterId);
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterRemovedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                ClusterRemovedEvent clusterRemovedEvent = (ClusterRemovedEvent)event;
                String serviceName = clusterRemovedEvent.getServiceName();
                String clusterId = clusterRemovedEvent.getClusterId();
                try {
                    TopologyManager.acquireReadLockForCluster((String)serviceName, (String)clusterId);
                    org.apache.stratos.messaging.domain.topology.Service service = TopologyManager.getTopology().getService(serviceName);
                    if (service == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)String.format("Service not found in topology: [service] %s", serviceName));
                        }
                        return;
                    }
                    Cluster cluster = service.getCluster(clusterId);
                    LoadBalancerCommonTopologyEventReceiver.this.removeCluster(cluster);
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForCluster((String)serviceName, (String)clusterId);
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ServiceRemovedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                ServiceRemovedEvent serviceRemovedEvent = (ServiceRemovedEvent)event;
                String serviceName = serviceRemovedEvent.getServiceName();
                try {
                    TopologyManager.acquireReadLockForService((String)serviceName);
                    org.apache.stratos.messaging.domain.topology.Service service = TopologyManager.getTopology().getService(serviceName);
                    if (service == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)String.format("Service not found in topology: [service] %s", serviceName));
                        }
                        return;
                    }
                    for (Cluster cluster : service.getClusters()) {
                        LoadBalancerCommonTopologyEventReceiver.this.removeCluster(cluster);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error processing event", (Throwable)e);
                }
                finally {
                    TopologyManager.releaseReadLockForService((String)serviceName);
                }
            }
        });
    }

    protected void removeCluster(Cluster cluster) {
        for (org.apache.stratos.messaging.domain.topology.Member member : cluster.getMembers()) {
            this.removeMember(member.getServiceName(), member.getClusterId(), member.getMemberId());
        }
    }

    protected void addMember(String serviceName, String clusterId, String memberId) {
        org.apache.stratos.messaging.domain.topology.Member member;
        org.apache.stratos.messaging.domain.topology.Service service = TopologyManager.getTopology().getService(serviceName);
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service not found in topology: [service] %s", serviceName));
            }
            return;
        }
        Cluster cluster = service.getCluster(clusterId);
        if (cluster == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Cluster not found in topology: [service] %s [cluster] %s", serviceName, clusterId));
            }
            return;
        }
        this.validateHostNames(cluster);
        if (!this.topologyProvider.serviceExists(serviceName)) {
            this.topologyProvider.addService(this.transformService(service));
        }
        if (!this.topologyProvider.clusterExistsByClusterId(cluster.getClusterId())) {
            this.topologyProvider.addCluster(this.transformCluster(cluster));
        }
        if ((member = cluster.getMember(memberId)) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Member not found in topology: [service] %s [cluster] %s [member] %s", serviceName, clusterId, memberId));
            }
            return;
        }
        Member lbMember = this.transformMember(member);
        Service lbService = this.topologyProvider.getTopology().getService(serviceName);
        if (lbService == null) {
            log.warn((Object)String.format("Service not found: %s", serviceName));
            return;
        }
        lbService.addPorts(lbMember.getPorts());
        this.topologyProvider.addMember(lbMember);
    }

    protected void removeMember(String serviceName, String clusterId, String memberId) {
        org.apache.stratos.messaging.domain.topology.Service service = TopologyManager.getTopology().getService(serviceName);
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service not found in topology: [service] %s", serviceName));
            }
            return;
        }
        Cluster cluster = service.getCluster(clusterId);
        if (cluster == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Cluster not found in topology: [service] %s [cluster] %s", serviceName, clusterId));
            }
            return;
        }
        this.validateHostNames(cluster);
        org.apache.stratos.messaging.domain.topology.Member member = cluster.getMember(memberId);
        if (member == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Member not found in topology: [service] %s [cluster] %s [member] %s", serviceName, clusterId, memberId));
            }
            return;
        }
        if (member != null) {
            this.topologyProvider.removeMember(cluster.getClusterId(), member.getMemberId());
        }
    }

    private void validateHostNames(Cluster cluster) {
        if (cluster.getHostNames() == null || cluster.getHostNames().size() == 0) {
            throw new RuntimeException(String.format("Host names not found in cluster: [cluster] %s", cluster.getClusterId()));
        }
    }

    private Service transformService(org.apache.stratos.messaging.domain.topology.Service messagingService) {
        Service service = new Service(messagingService.getServiceName());
        return service;
    }

    private org.apache.stratos.load.balancer.common.domain.Port transformPort(Port messagingPort) {
        org.apache.stratos.load.balancer.common.domain.Port port = new org.apache.stratos.load.balancer.common.domain.Port(messagingPort.getProtocol(), messagingPort.getValue(), messagingPort.getProxy());
        return port;
    }

    private org.apache.stratos.load.balancer.common.domain.Cluster transformCluster(Cluster messagingCluster) {
        org.apache.stratos.load.balancer.common.domain.Cluster cluster = new org.apache.stratos.load.balancer.common.domain.Cluster(messagingCluster.getServiceName(), messagingCluster.getClusterId());
        cluster.setTenantRange(messagingCluster.getTenantRange());
        if (messagingCluster.getHostNames() != null) {
            for (String hostName : messagingCluster.getHostNames()) {
                cluster.addHostName(hostName);
            }
        }
        Properties messagingClusterProps = new Properties();
        if (messagingCluster.getAppId() != null) {
            messagingClusterProps.setProperty("applicationId", messagingCluster.getAppId());
        }
        cluster.setProperties(messagingClusterProps);
        return cluster;
    }

    private Member transformMember(org.apache.stratos.messaging.domain.topology.Member messagingMember) {
        String hostName;
        if (messagingMember.getLoadBalancingIPType() == LoadBalancingIPType.Private) {
            if (StringUtils.isEmpty((CharSequence)messagingMember.getDefaultPrivateIP())) {
                throw new RuntimeException(String.format("Default private IP not found: [member] %s", messagingMember.getMemberId()));
            }
            hostName = messagingMember.getDefaultPrivateIP();
        } else if (messagingMember.getLoadBalancingIPType() == LoadBalancingIPType.Public) {
            if (StringUtils.isEmpty((CharSequence)messagingMember.getDefaultPublicIP())) {
                throw new RuntimeException(String.format("Default public IP not found: [member] %s", messagingMember.getMemberId()));
            }
            hostName = messagingMember.getDefaultPublicIP();
        } else {
            throw new RuntimeException(String.format("Unknown load balancing IP type found: %s", messagingMember.getLoadBalancingIPType()));
        }
        Member member = new Member(messagingMember.getServiceName(), messagingMember.getClusterId(), messagingMember.getMemberId(), hostName);
        if (messagingMember.getPorts() != null) {
            for (Port port : messagingMember.getPorts()) {
                member.addPort(this.transformPort(port));
            }
        }
        if (messagingMember.getInstanceId() != null) {
            member.setInstanceId(messagingMember.getInstanceId());
        }
        member.setProperties(messagingMember.getProperties());
        return member;
    }
}

