/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.beans.cartridge;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.stratos.common.beans.PropertyBean;
import org.apache.stratos.common.beans.cartridge.DeploymentBean;
import org.apache.stratos.common.beans.cartridge.IaasProviderBean;
import org.apache.stratos.common.beans.cartridge.PersistenceBean;
import org.apache.stratos.common.beans.cartridge.PortMappingBean;

@XmlRootElement(name="cartridgeBean")
public class CartridgeBean {
    private String type;
    private String provider;
    private String category;
    private String host;
    private String displayName;
    private String description;
    private String version;
    private boolean multiTenant;
    private DeploymentBean deployment;
    private List<PortMappingBean> portMapping;
    private List<String> metadataKeys;
    private List<IaasProviderBean> iaasProvider;
    private PersistenceBean persistence;
    private String loadBalancingIPType;
    private List<PropertyBean> property;

    private String getDeploymentDetails() {
        if (this.getDeployment() != null) {
            return this.getDeployment().toString();
        }
        return null;
    }

    private String getPortMappings() {
        StringBuilder portMappingBuilder = new StringBuilder();
        if (this.getPortMapping() != null && !this.getPortMapping().isEmpty()) {
            for (PortMappingBean portMappingBean : this.getPortMapping()) {
                portMappingBuilder.append(portMappingBean.toString());
            }
        }
        return portMappingBuilder.toString();
    }

    private String getIaasProviders() {
        StringBuilder iaasBuilder = new StringBuilder();
        if (this.getIaasProvider() != null && !this.getIaasProvider().isEmpty()) {
            for (IaasProviderBean iaasProviderBean : this.getIaasProvider()) {
                iaasBuilder.append(iaasProviderBean.toString());
            }
        }
        return iaasBuilder.toString();
    }

    private String getProperties() {
        StringBuilder propertyBuilder = new StringBuilder();
        if (this.getProperty() != null) {
            for (PropertyBean propertyBean : this.getProperty()) {
                propertyBuilder.append(propertyBean.getName() + " : " + propertyBean.getValue() + " | ");
            }
        }
        return propertyBuilder.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isMultiTenant() {
        return this.multiTenant;
    }

    public void setMultiTenant(boolean multiTenant) {
        this.multiTenant = multiTenant;
    }

    public DeploymentBean getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentBean deployment) {
        this.deployment = deployment;
    }

    public List<PortMappingBean> getPortMapping() {
        return this.portMapping;
    }

    public void setPortMapping(List<PortMappingBean> portMapping) {
        this.portMapping = portMapping;
    }

    public PersistenceBean getPersistence() {
        return this.persistence;
    }

    public void setPersistence(PersistenceBean persistence) {
        this.persistence = persistence;
    }

    public List<IaasProviderBean> getIaasProvider() {
        return this.iaasProvider;
    }

    public void setIaasProvider(List<IaasProviderBean> iaasProvider) {
        this.iaasProvider = iaasProvider;
    }

    public List<PropertyBean> getProperty() {
        return this.property;
    }

    public void setProperty(List<PropertyBean> property) {
        this.property = property;
    }

    public String getLoadBalancingIPType() {
        return this.loadBalancingIPType;
    }

    public void setLoadBalancingIPType(String loadBalancingIPType) {
        this.loadBalancingIPType = loadBalancingIPType;
    }

    public String toString() {
        return "Type: " + this.getType() + ", Provider: " + this.getProvider() + ", Category: " + this.getCategory() + ", Host: " + this.getHost() + ", Display Name: " + this.getDisplayName() + ", Description: " + this.getDescription() + ", Version: " + this.getVersion() + ", Multi-Tenant " + this.isMultiTenant() + ", Deployment" + this.getDeploymentDetails() + ", Port Mapping: " + this.getPortMappings() + ", IaaS Providers: " + this.getIaasProviders() + ", Metadata keys: " + this.getMetadataKeys() + ", Persistence " + (this.getPersistence() == null ? "" : this.getPersistence().toString()) + ", Load Balancing IP Type: " + this.getLoadBalancingIPType() + ", Properties: " + this.getProperties();
    }

    public List<String> getMetadataKeys() {
        return this.metadataKeys;
    }

    public void setMetadataKeys(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }
}

