/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret.mbean;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.secret.mbean.JMXSecretsProviderMBean;

public class JMXSecretsProvider
implements JMXSecretsProviderMBean {
    private static final Log log = LogFactory.getLog(JMXSecretsProvider.class);
    private final Map<String, String> secrets = new HashMap<String, String>();

    public void addSecret(String id, String secret) {
        this.assertIdEmpty(id);
        this.assertSecretEmpty(secret);
        this.secrets.put(id, secret);
    }

    public String getSecret(String id) {
        this.assertIdEmpty(id);
        return this.secrets.get(id);
    }

    public void removeSecret(String id) {
        this.assertIdEmpty(id);
        this.secrets.remove(id);
    }

    public void clear() {
        this.secrets.clear();
    }

    private void assertIdEmpty(String id) {
        if (id == null || "".equals(id)) {
            this.handleException("ID cannot be empty or null");
        }
    }

    private void assertSecretEmpty(String secret) {
        if (secret == null || "".equals(secret)) {
            this.handleException("Secret cannot be empty or null");
        }
    }

    private void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }
}

