/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyRegistry;

public class PolicyReference
implements PolicyComponent {
    private String uri;

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (4 != policyComponent.getType()) {
            return false;
        }
        String URI2 = ((PolicyReference)policyComponent).getURI();
        if (URI2 != null && URI2.length() != 0) {
            return URI2.equals(this.uri);
        }
        return false;
    }

    public short getType() {
        return 4;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException("PolicyReference.normalize() is meaningless");
    }

    public PolicyComponent normalize(PolicyRegistry reg, boolean deep) {
        String key = this.getURI();
        int pos = key.indexOf("#");
        if (pos == 0) {
            key = key.substring(1);
        } else if (pos > 0) {
            key = key.substring(0, pos);
        }
        Policy policy = reg.lookup(key);
        if (policy == null && (policy = this.getRemoteReferencedPolicy(key)) == null) {
            throw new RuntimeException(key + " can't be resolved");
        }
        return policy.normalize(reg, deep);
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix = writer.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (wspPrefix == null) {
            wspPrefix = "wsp";
            writer.setPrefix(wspPrefix, "http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        writer.writeStartElement(wspPrefix, "PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        writer.writeAttribute("URI", this.getURI());
        writer.writeEndElement();
    }

    public OMElement getRemoteReferedElement(String uri) {
        OMElement documentElement = null;
        try {
            XMLStreamReader parser;
            URLConnection connection;
            URL url = new URL(uri);
            if ("https".equals(url.getProtocol())) {
                connection = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
                connection.setDoInput(true);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(connection.getInputStream());
            } else {
                connection = url.openConnection();
                connection.setDoInput(true);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(connection.getInputStream());
            }
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            documentElement = builder.getDocumentElement();
        }
        catch (XMLStreamException se) {
            throw new RuntimeException("Bad policy content: " + uri);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Malformed uri: " + uri);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot reach remote resource: " + uri);
        }
        return documentElement;
    }

    public Policy getRemoteReferencedPolicy(String uri) {
        Policy policy = null;
        OMElement policyElement = this.getRemoteReferedElement(uri);
        policy = PolicyEngine.getPolicy(policyElement);
        return policy;
    }
}

