/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Phase
implements Handler {
    public static final String ALL_PHASES = "*";
    private static final Log log = LogFactory.getLog(Phase.class);
    private static boolean isDebugEnabled = LoggingControl.debugLoggingAllowed && log.isDebugEnabled();
    private List<Handler> handlers = new CopyOnWriteArrayList<Handler>();
    private boolean isOneHandler;
    private String phaseName;
    private boolean phaseFirstSet;
    private boolean phaseLastSet;

    public Phase() {
        this(null);
    }

    public Phase(String phaseName) {
        this.phaseName = phaseName;
    }

    public void addHandler(Handler handler) {
        log.debug("Handler " + handler.getName() + " added to Phase " + this.phaseName);
        if (this.phaseLastSet) {
            if (this.handlers.size() == 1) {
                this.handlers.add(0, handler);
            } else {
                this.handlers.add(this.handlers.size() - 2, handler);
            }
        } else {
            this.handlers.add(handler);
        }
    }

    public void addHandler(HandlerDescription handlerDesc) throws PhaseException {
        for (Handler hand : this.getHandlers()) {
            HandlerDescription thisDesc = hand.getHandlerDesc();
            if (!handlerDesc.getName().equals(thisDesc.getName())) continue;
            return;
        }
        if (this.isOneHandler) {
            throw new PhaseException("Phase '" + this.getPhaseName() + "' can only have one handler, since there is a " + "handler with both phaseFirst and phaseLast true ");
        }
        if (handlerDesc.getRules().isPhaseFirst() && handlerDesc.getRules().isPhaseLast()) {
            if (!this.handlers.isEmpty()) {
                throw new PhaseException(this.getPhaseName() + " already contains Handlers, and " + handlerDesc.getName() + " cannot therefore be both phaseFirst and phaseLast.");
            }
            this.handlers.add(handlerDesc.getHandler());
            this.isOneHandler = true;
        } else if (handlerDesc.getRules().isPhaseFirst()) {
            this.setPhaseFirst(handlerDesc.getHandler());
        } else if (handlerDesc.getRules().isPhaseLast()) {
            this.setPhaseLast(handlerDesc.getHandler());
        } else {
            this.insertHandler(handlerDesc);
        }
    }

    public void addHandler(Handler handler, int index) {
        if (log.isDebugEnabled()) {
            log.debug("Handler " + handler.getName() + " inserted at position " + index + " of Phase " + this.phaseName);
        }
        this.handlers.add(index, handler);
    }

    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
    }

    public void checkPreconditions(MessageContext msgContext) throws AxisFault {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void init(HandlerDescription handlerdesc) {
    }

    private void insertHandler(HandlerDescription handlerDesc) throws PhaseException {
        Handler handler = handlerDesc.getHandler();
        PhaseRule rules = handler.getHandlerDesc().getRules();
        String beforeName = rules.getBefore();
        String afterName = rules.getAfter();
        if (beforeName == null && afterName == null) {
            this.addHandler(handler);
            return;
        }
        int beforeIndex = -1;
        int afterIndex = -1;
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler tempHandler = this.handlers.get(i);
            if (beforeName != null && beforeIndex == -1 && tempHandler.getName().equals(beforeName)) {
                beforeIndex = i;
            }
            if (afterName == null || afterIndex != -1 || !tempHandler.getName().equals(afterName)) continue;
            afterIndex = i;
        }
        if (beforeIndex > -1 && afterIndex >= beforeIndex) {
            throw new PhaseException("Can't insert handler because " + beforeName + " is before " + afterName + " in Phase '" + this.phaseName + "'");
        }
        if (this.phaseFirstSet && beforeIndex == 0) {
            throw new PhaseException("Can't insert handler before handler '" + beforeName + "', which is marked phaseFirst");
        }
        if (this.phaseLastSet && afterIndex == this.handlers.size() - 1) {
            throw new PhaseException("Can't insert handler after handler '" + afterName + "', which is marked phaseLast");
        }
        if (beforeIndex > -1) {
            this.handlers.add(beforeIndex, handler);
        } else if (afterIndex > -1) {
            if (this.phaseLastSet) {
                if (this.handlers.size() == 1) {
                    this.handlers.add(0, handler);
                } else {
                    this.handlers.add(this.handlers.size() - 2, handler);
                }
            } else if (afterIndex == this.handlers.size() - 1) {
                this.handlers.add(handler);
            } else {
                this.handlers.add(afterIndex + 1, handler);
            }
        } else if (this.phaseLastSet) {
            if (this.handlers.size() == 1) {
                this.handlers.add(0, handler);
            } else {
                this.handlers.add(this.handlers.size() - 2, handler);
            }
        } else {
            this.handlers.add(handler);
        }
    }

    @Override
    public final Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        int currentIndex;
        if (isDebugEnabled) {
            log.debug(msgctx.getLogIDString() + " Checking pre-condition for Phase \"" + this.phaseName + "\"");
        }
        if ((currentIndex = msgctx.getCurrentPhaseIndex()) == 0) {
            this.checkPreconditions(msgctx);
        }
        if (isDebugEnabled) {
            log.debug(msgctx.getLogIDString() + " Invoking phase \"" + this.phaseName + "\"");
        }
        int handlersSize = this.handlers.size();
        for (int i = currentIndex; i < handlersSize; ++i) {
            Handler handler = this.handlers.get(i);
            Handler.InvocationResponse pi = this.invokeHandler(handler, msgctx);
            if (!pi.equals(Handler.InvocationResponse.CONTINUE)) {
                return pi;
            }
            msgctx.setCurrentPhaseIndex(i + 1);
        }
        if (isDebugEnabled) {
            log.debug(msgctx.getLogIDString() + " Checking post-conditions for phase \"" + this.phaseName + "\"");
        }
        msgctx.setCurrentPhaseIndex(0);
        this.checkPostConditions(msgctx);
        return Handler.InvocationResponse.CONTINUE;
    }

    private Handler.InvocationResponse invokeHandler(Handler handler, MessageContext msgctx) throws AxisFault {
        if (isDebugEnabled) {
            log.debug(msgctx.getLogIDString() + " Invoking Handler '" + handler.getName() + "' in Phase '" + this.phaseName + "'");
        }
        return handler.invoke(msgctx);
    }

    @Override
    public void flowComplete(MessageContext msgContext) {
        int currentHandlerIndex;
        if (isDebugEnabled) {
            log.debug(msgContext.getLogIDString() + " Invoking flowComplete() in Phase \"" + this.phaseName + "\"");
        }
        if ((currentHandlerIndex = msgContext.getCurrentPhaseIndex()) == 0) {
            currentHandlerIndex = this.handlers.size();
        } else {
            msgContext.setCurrentPhaseIndex(0);
        }
        while (currentHandlerIndex > 0) {
            Handler handler = this.handlers.get(currentHandlerIndex - 1);
            if (isDebugEnabled) {
                log.debug(msgContext.getLogIDString() + " Invoking flowComplete() for Handler '" + handler.getName() + "' in Phase '" + this.phaseName + "'");
            }
            handler.flowComplete(msgContext);
            --currentHandlerIndex;
        }
    }

    public String toString() {
        return this.getPhaseName();
    }

    public int getHandlerCount() {
        return this.handlers.size();
    }

    @Override
    public HandlerDescription getHandlerDesc() {
        return null;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    @Override
    public String getName() {
        return this.phaseName;
    }

    @Override
    public Parameter getParameter(String name) {
        return null;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setName(String phaseName) {
        this.phaseName = phaseName;
    }

    public void setPhaseFirst(Handler handler) throws PhaseException {
        if (this.phaseFirstSet) {
            throw new PhaseException("PhaseFirst has been set already, cannot have two phaseFirst Handlers for Phase '" + this.getPhaseName() + "'");
        }
        this.handlers.add(0, handler);
        this.phaseFirstSet = true;
    }

    public void setPhaseLast(Handler handler) throws PhaseException {
        if (this.phaseLastSet) {
            throw new PhaseException("PhaseLast already has been set, cannot have two PhaseLast Handler for same phase " + this.getPhaseName());
        }
        this.handlers.add(handler);
        this.phaseLastSet = true;
    }

    public void removeHandler(HandlerDescription handlerDesc) {
        if (this.handlers.remove(handlerDesc.getHandler())) {
            PhaseRule rule = handlerDesc.getRules();
            if (rule.isPhaseFirst()) {
                this.phaseFirstSet = false;
            }
            if (rule.isPhaseLast()) {
                this.phaseLastSet = false;
            }
            if (rule.isPhaseFirst() && rule.isPhaseLast()) {
                this.isOneHandler = false;
            }
            log.debug("removed handler " + handlerDesc.getName() + " from the phase " + this.phaseName);
        } else {
            log.debug("unable to remove handler " + handlerDesc.getName() + " from the phase " + this.phaseName);
        }
    }
}

