/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.ClearOperation;
import com.hazelcast.collection.operations.ContainsEntryOperation;
import com.hazelcast.collection.operations.EntrySetOperation;
import com.hazelcast.collection.operations.KeySetOperation;
import com.hazelcast.collection.operations.SizeOperation;
import com.hazelcast.collection.operations.ValuesOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;

public class MultiMapOperationFactory
implements OperationFactory {
    private CollectionProxyId proxyId;
    private OperationFactoryType operationFactoryType;
    private Data key;
    private Data value;

    public MultiMapOperationFactory() {
    }

    public MultiMapOperationFactory(CollectionProxyId proxyId, OperationFactoryType operationFactoryType) {
        this.proxyId = proxyId;
        this.operationFactoryType = operationFactoryType;
    }

    public MultiMapOperationFactory(CollectionProxyId proxyId, OperationFactoryType operationFactoryType, Data key, Data value) {
        this(proxyId, operationFactoryType);
        this.key = key;
        this.value = value;
    }

    @Override
    public Operation createOperation() {
        if (this.operationFactoryType == OperationFactoryType.KEY_SET) {
            return new KeySetOperation(this.proxyId);
        }
        if (this.operationFactoryType == OperationFactoryType.VALUES) {
            return new ValuesOperation(this.proxyId);
        }
        if (this.operationFactoryType == OperationFactoryType.ENTRY_SET) {
            return new EntrySetOperation(this.proxyId);
        }
        if (this.operationFactoryType == OperationFactoryType.CONTAINS) {
            return new ContainsEntryOperation(this.proxyId, this.key, this.value);
        }
        if (this.operationFactoryType == OperationFactoryType.SIZE) {
            return new SizeOperation(this.proxyId);
        }
        if (this.operationFactoryType == OperationFactoryType.CLEAR) {
            return new ClearOperation(this.proxyId);
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.proxyId.writeData(out);
        out.writeInt(this.operationFactoryType.type);
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
        this.operationFactoryType = OperationFactoryType.getByType(in.readInt());
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
    }

    public static enum OperationFactoryType {
        KEY_SET(1),
        VALUES(2),
        ENTRY_SET(3),
        CONTAINS(4),
        SIZE(5),
        CLEAR(6);

        final int type;

        private OperationFactoryType(int type) {
            this.type = type;
        }

        static OperationFactoryType getByType(int type) {
            for (OperationFactoryType factoryType : OperationFactoryType.values()) {
                if (factoryType.type != type) continue;
                return factoryType;
            }
            return null;
        }
    }
}

