/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;

public class EC5Util {
    static EllipticCurve convertCurve(ECCurve eCCurve, byte[] byArray) {
        if (eCCurve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)eCCurve).getQ()), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
        }
        ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
        if (f2m.isTrinomial()) {
            int[] nArray = new int[]{f2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
        }
        int[] nArray = new int[]{f2m.getK3(), f2m.getK2(), f2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), byArray);
    }

    static java.security.spec.ECParameterSpec convertSpec(EllipticCurve ellipticCurve, ECParameterSpec eCParameterSpec) {
        return new java.security.spec.ECParameterSpec(ellipticCurve, new ECPoint(eCParameterSpec.getG().getX().toBigInteger(), eCParameterSpec.getG().getY().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
    }
}

