/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.transport.base.threads.Axis2ThreadPoolExecutor;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.watermark.DefaultWaterMarkQueue;
import org.apache.axis2.transport.base.threads.watermark.WaterMarkExecutor;
import org.apache.axis2.transport.base.threads.watermark.WaterMarkQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeWorkerPool
implements WorkerPool {
    static final Log log = LogFactory.getLog(NativeWorkerPool.class);
    private final ThreadPoolExecutor executor;
    private final BlockingQueue<Runnable> blockingQueue;

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queueLength == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(queueLength);
        this.executor = new Axis2ThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, this.blockingQueue, new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId, BlockingQueue<Runnable> queue) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queue == null ? (queueLength == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(queueLength)) : queue;
        this.executor = new Axis2ThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, this.blockingQueue, new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId, BlockingQueue<Runnable> queue, RejectedExecutionHandler rejectedExecutionHandler) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queue == null ? (queueLength == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(queueLength)) : queue;
        this.executor = new Axis2ThreadPoolExecutor(core, max, keepAlive, TimeUnit.SECONDS, this.blockingQueue, new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId), rejectedExecutionHandler);
    }

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, int waterMark, String threadGroupName, String threadGroupId) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queueLength == -1 ? new DefaultWaterMarkQueue<Runnable>(waterMark) : new DefaultWaterMarkQueue(waterMark, queueLength);
        this.executor = new WaterMarkExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, (WaterMarkQueue<Runnable>)((WaterMarkQueue)this.blockingQueue), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, int waterMark, String threadGroupName, String threadGroupId, WaterMarkQueue<Runnable> queue) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queue == null ? (queueLength == -1 ? new DefaultWaterMarkQueue<Runnable>(waterMark) : new DefaultWaterMarkQueue(waterMark, queueLength)) : queue;
        this.executor = new WaterMarkExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, (WaterMarkQueue<Runnable>)((WaterMarkQueue)this.blockingQueue), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public NativeWorkerPool(int core, int max, int keepAlive, int queueLength, int waterMark, String threadGroupName, String threadGroupId, RejectedExecutionHandler rejectedExecutionHandler) {
        if (log.isDebugEnabled()) {
            log.debug("Using native util.concurrent package..");
        }
        this.blockingQueue = queueLength == -1 ? new DefaultWaterMarkQueue<Runnable>(waterMark) : new DefaultWaterMarkQueue(waterMark, queueLength);
        this.executor = new WaterMarkExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, (WaterMarkQueue)this.blockingQueue, (ThreadFactory)new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId), rejectedExecutionHandler);
    }

    @Override
    public void execute(final Runnable task) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error("Uncaught exception", t);
                }
            }
        });
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getQueueSize() {
        return this.blockingQueue.size();
    }

    @Override
    public void shutdown(int timeout) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
    }
}

