/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.util;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControllingBlockingQueue {
    private static final Logger _logger = LoggerFactory.getLogger(FlowControllingBlockingQueue.class);
    private final Queue _queue = new ConcurrentLinkedQueue();
    private final int _flowControlHighThreshold;
    private final int _flowControlLowThreshold;
    private final ThresholdListener _listener;
    private int _count;
    private boolean disableFlowControl;

    public boolean isEmpty() {
        return this._queue.isEmpty();
    }

    public FlowControllingBlockingQueue(int threshold, ThresholdListener listener) {
        this(threshold, threshold, listener);
    }

    public FlowControllingBlockingQueue(int highThreshold, int lowThreshold, ThresholdListener listener) {
        this._flowControlHighThreshold = highThreshold;
        this._flowControlLowThreshold = lowThreshold;
        this._listener = listener;
        if (highThreshold == 0) {
            this.disableFlowControl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object object;
        Object o = this._queue.poll();
        if (o == null) {
            object = this;
            synchronized (object) {
                while ((o = this._queue.poll()) == null) {
                    this.wait();
                }
            }
        }
        if (!this.disableFlowControl && this._listener != null) {
            object = this._listener;
            synchronized (object) {
                if (this._count-- == this._flowControlLowThreshold) {
                    this._listener.underThreshold(this._count);
                }
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o) {
        Object object = this;
        synchronized (object) {
            this._queue.add(o);
            this.notifyAll();
        }
        if (!this.disableFlowControl && this._listener != null) {
            object = this._listener;
            synchronized (object) {
                if (++this._count == this._flowControlHighThreshold) {
                    this._listener.aboveThreshold(this._count);
                }
            }
        }
    }

    public Iterator iterator() {
        return this._queue.iterator();
    }

    public static interface ThresholdListener {
        public void aboveThreshold(int var1);

        public void underThreshold(int var1);
    }
}

