/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PostJoinMapOperation
extends AbstractOperation
implements JoinOperation {
    private List<MapIndexInfo> indexInfoList = new LinkedList<MapIndexInfo>();
    private List<InterceptorInfo> interceptorInfoList = new LinkedList<InterceptorInfo>();

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    public void addMapIndex(MapContainer mapContainer) {
        IndexService indexService = mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapContainer.getName());
            for (Index index : indexService.getIndexes()) {
                mapIndexInfo.addIndexInfo(index.getAttributeName(), index.isOrdered());
            }
            this.indexInfoList.add(mapIndexInfo);
        }
    }

    public void addMapInterceptors(MapContainer mapContainer) {
        List<MapInterceptor> interceptorList = mapContainer.getInterceptors();
        Map<String, MapInterceptor> interceptorMap = mapContainer.getInterceptorMap();
        HashMap<MapInterceptor, String> revMap = new HashMap<MapInterceptor, String>();
        for (Map.Entry<String, MapInterceptor> entry : interceptorMap.entrySet()) {
            revMap.put(entry.getValue(), entry.getKey());
        }
        InterceptorInfo interceptorInfo = new InterceptorInfo(mapContainer.getName());
        for (MapInterceptor interceptor : interceptorList) {
            interceptorInfo.addInterceptor((String)revMap.get(interceptor), interceptor);
        }
        this.interceptorInfoList.add(interceptorInfo);
    }

    @Override
    public void run() throws Exception {
        MapContainer mapContainer;
        MapService mapService = (MapService)this.getService();
        for (MapIndexInfo mapIndex : this.indexInfoList) {
            mapContainer = mapService.getMapContainer(mapIndex.mapName);
            IndexService indexService = mapContainer.getIndexService();
            for (MapIndexInfo.IndexInfo indexInfo : mapIndex.lsIndexes) {
                indexService.addOrGetIndex(indexInfo.attributeName, indexInfo.ordered);
            }
        }
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            mapContainer = mapService.getMapContainer(interceptorInfo.mapName);
            Map<String, MapInterceptor> interceptorMap = mapContainer.getInterceptorMap();
            List<Map.Entry<String, MapInterceptor>> entryList = interceptorInfo.interceptors;
            for (Map.Entry<String, MapInterceptor> entry : entryList) {
                if (interceptorMap.containsKey(entry.getKey())) continue;
                mapContainer.addInterceptor(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.indexInfoList.size());
        for (MapIndexInfo mapIndex : this.indexInfoList) {
            mapIndex.writeData(out);
        }
        out.writeInt(this.interceptorInfoList.size());
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            interceptorInfo.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MapIndexInfo mapIndexInfo = new MapIndexInfo();
            mapIndexInfo.readData(in);
            this.indexInfoList.add(mapIndexInfo);
        }
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            InterceptorInfo info = new InterceptorInfo();
            info.readData(in);
            this.interceptorInfoList.add(info);
        }
    }

    class MapIndexInfo
    implements DataSerializable {
        String mapName;
        private List<IndexInfo> lsIndexes = new LinkedList<IndexInfo>();

        public MapIndexInfo(String mapName) {
            this.mapName = mapName;
        }

        public MapIndexInfo() {
        }

        public void addIndexInfo(String attributeName, boolean ordered) {
            this.lsIndexes.add(new IndexInfo(attributeName, ordered));
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            out.writeInt(this.lsIndexes.size());
            for (IndexInfo indexInfo : this.lsIndexes) {
                indexInfo.writeData(out);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                IndexInfo indexInfo = new IndexInfo();
                indexInfo.readData(in);
                this.lsIndexes.add(indexInfo);
            }
        }

        class IndexInfo
        implements DataSerializable {
            String attributeName;
            boolean ordered;

            IndexInfo() {
            }

            IndexInfo(String attributeName, boolean ordered) {
                this.attributeName = attributeName;
                this.ordered = ordered;
            }

            @Override
            public void writeData(ObjectDataOutput out) throws IOException {
                out.writeUTF(this.attributeName);
                out.writeBoolean(this.ordered);
            }

            @Override
            public void readData(ObjectDataInput in) throws IOException {
                this.attributeName = in.readUTF();
                this.ordered = in.readBoolean();
            }
        }
    }

    class InterceptorInfo
    implements DataSerializable {
        String mapName;
        List<Map.Entry<String, MapInterceptor>> interceptors = new LinkedList<Map.Entry<String, MapInterceptor>>();

        InterceptorInfo(String mapName) {
            this.mapName = mapName;
        }

        InterceptorInfo() {
        }

        void addInterceptor(String id, MapInterceptor interceptor) {
            this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            out.writeInt(this.interceptors.size());
            for (Map.Entry<String, MapInterceptor> entry : this.interceptors) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String id = in.readUTF();
                MapInterceptor interceptor = (MapInterceptor)in.readObject();
                this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
            }
        }
    }
}

