/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.concurrent.locks.ReadWriteLock;
import org.apache.stratos.messaging.domain.tenant.Tenant;

public class TenantManager {
    private static final Log log = LogFactory.getLog(TenantManager.class);
    private static volatile TenantManager instance;
    private static volatile ReadWriteLock lock;
    private Map<Integer, Tenant> tenantIdTenantMap = new HashMap<Integer, Tenant>();
    private Map<String, Tenant> tenantDomainTenantMap = new HashMap<String, Tenant>();
    private boolean initialized;

    public static void acquireReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired");
        }
        lock.acquireReadLock();
    }

    public static void releaseReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released");
        }
        lock.releaseReadLock();
    }

    public static void acquireWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired");
        }
        lock.acquireWriteLock();
    }

    public static void releaseWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released");
        }
        lock.releaseWriteLock();
    }

    private TenantManager() {
        Tenant superTenant = new Tenant(-1234, "carbon.super");
        this.tenantIdTenantMap.put(-1234, superTenant);
        this.tenantDomainTenantMap.put("carbon.super", superTenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantManager getInstance() {
        if (instance != null) return instance;
        Class<TenantManager> clazz = TenantManager.class;
        synchronized (TenantManager.class) {
            if (instance != null) return instance;
            instance = new TenantManager();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"TenantManager object created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addTenant(Tenant tenant) {
        this.tenantIdTenantMap.put(tenant.getTenantId(), tenant);
        this.tenantDomainTenantMap.put(tenant.getTenantDomain(), tenant);
    }

    public void addTenants(List<Tenant> tenants) {
        for (Tenant tenant : tenants) {
            this.addTenant(tenant);
        }
    }

    public Tenant getTenant(int tenantId) {
        return this.tenantIdTenantMap.get(tenantId);
    }

    public Tenant getTenant(String tenantDomain) {
        return this.tenantDomainTenantMap.get(tenantDomain);
    }

    public boolean tenantExists(int tenantId) {
        return this.tenantIdTenantMap.containsKey(tenantId);
    }

    public void removeTenant(int tenantId) {
        Tenant tenant = this.getTenant(tenantId);
        if (tenant != null) {
            this.tenantIdTenantMap.remove(tenant.getTenantId());
            this.tenantDomainTenantMap.remove(tenant.getTenantDomain());
        }
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static {
        lock = new ReadWriteLock("tenant-manager");
    }
}

