/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.event.topology;

import java.util.ArrayList;
import java.util.List;
import org.apache.stratos.messaging.event.Event;

public class ClusterInstanceActivatedEvent
extends Event {
    private final String serviceName;
    private final String clusterId;
    private String appId;
    private String instanceId;
    private List<String> accessUrls;
    private List<String> loadBalancerIps;

    public ClusterInstanceActivatedEvent(String appId, String serviceName, String clusterId, String instanceId) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.appId = appId;
        this.instanceId = instanceId;
        this.accessUrls = new ArrayList<String>();
        this.loadBalancerIps = new ArrayList<String>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String toString() {
        return "ClusterActivatedEvent [serviceName=" + this.serviceName + ", clusterStatus=" + "]";
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<String> getAccessUrls() {
        return this.accessUrls;
    }

    public void setAccessUrls(List<String> accessUrls) {
        this.accessUrls = accessUrls;
    }

    public void addAccessUrl(String accessUrl) {
        if (this.accessUrls == null) {
            this.accessUrls = new ArrayList<String>();
        }
        if (!this.accessUrls.contains(accessUrl)) {
            this.accessUrls.add(accessUrl);
        }
    }

    public void setLoadBalancerIps(List<String> loadBalancerIps) {
        this.loadBalancerIps = loadBalancerIps;
    }

    public List<String> getLoadBalancerIps() {
        return this.loadBalancerIps;
    }
}

