/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.permission;

import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class ManagementPermissionUtil {
    public static void updateRoleUIPermission(String roleName, String[] rawPermissions) throws UserAdminException {
        try {
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawPermissions);
            UserRealm realm = AdminServicesUtil.getUserRealm();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            for (String path : optimizedList) {
                authMan.authorizeRole(roleName, path, "ui.execute");
            }
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (CarbonException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public static Permission[] getRoleUIPermissions(String roleName, String[] rawPermissions) throws UserAdminException {
        Permission[] permissions = new Permission[]{};
        try {
            if (rawPermissions == null || rawPermissions.length == 0) {
                return permissions;
            }
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawPermissions);
            UserRealm realm = AdminServicesUtil.getUserRealm();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            permissions = new Permission[optimizedList.length];
            int i = 0;
            for (String path : optimizedList) {
                permissions[i++] = new Permission(path, "ui.execute");
            }
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (CarbonException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        return permissions;
    }
}

