/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.util.ConstructorFunction;

public class ArrayPortableFactory
implements PortableFactory {
    private final ConstructorFunction<Integer, Portable>[] constructors;
    private final int len;

    public ArrayPortableFactory(ConstructorFunction<Integer, Portable>[] ctorArray) {
        if (ctorArray != null && ctorArray.length > 0) {
            this.len = ctorArray.length;
            this.constructors = new ConstructorFunction[this.len];
            System.arraycopy(ctorArray, 0, this.constructors, 0, this.len);
        } else {
            this.len = 0;
            this.constructors = new ConstructorFunction[this.len];
        }
    }

    @Override
    public Portable create(int classId) {
        if (classId >= 0 && classId < this.len) {
            ConstructorFunction<Integer, Portable> factory = this.constructors[classId];
            return factory != null ? factory.createNew(classId) : null;
        }
        return null;
    }
}

