/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

public class ExecutorConfig {
    public static final int DEFAULT_POOL_SIZE = 8;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private String name = "default";
    private int poolSize = 8;
    private int queueCapacity = Integer.MAX_VALUE;
    private boolean statisticsEnabled = true;

    public ExecutorConfig() {
    }

    public ExecutorConfig(String name) {
        this.name = name;
    }

    public ExecutorConfig(String name, int poolSize) {
        this.name = name;
        this.poolSize = poolSize;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ExecutorConfig setPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be positive");
        }
        this.poolSize = poolSize;
        return this;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public ExecutorConfig setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ExecutorConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutorConfig");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", poolSize=").append(this.poolSize);
        sb.append(", queueCapacity=").append(this.queueCapacity);
        sb.append('}');
        return sb.toString();
    }
}

