/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.pool.client.secure;

import java.net.SocketException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentSecurityException;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;

public class SecureClientPoolFactory
extends BaseKeyedPoolableObjectFactory {
    private TSSLTransportFactory.TSSLTransportParameters params;
    private String trustStorePassword;
    private String trustStore;

    public SecureClientPoolFactory(String trustStorePassword, String trustStore) {
        this.trustStorePassword = trustStorePassword;
        this.trustStore = trustStore;
    }

    public ThriftSecureEventTransmissionService.Client makeObject(Object key) throws AgentSecurityException, TTransportException {
        String[] keyElements = key.toString().split(",");
        if (keyElements[2].equals(ReceiverConfiguration.Protocol.TCP.toString())) {
            if (this.params == null) {
                if (this.trustStore == null) {
                    this.trustStore = System.getProperty("javax.net.ssl.trustStore");
                    if (this.trustStore == null) {
                        throw new AgentSecurityException("No trustStore found");
                    }
                }
                if (this.trustStorePassword == null) {
                    this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                    if (this.trustStorePassword == null) {
                        throw new AgentSecurityException("No trustStore password found");
                    }
                }
                this.params = new TSSLTransportFactory.TSSLTransportParameters();
                this.params.setTrustStore(this.trustStore, this.trustStorePassword);
            }
            String[] hostNameAndPort = keyElements[3].split(":");
            TSocket receiverTransport = null;
            try {
                receiverTransport = TSSLTransportFactory.getClientSocket((String)HostAddressFinder.findAddress((String)hostNameAndPort[0]), (int)Integer.parseInt(hostNameAndPort[1]), (int)0, (TSSLTransportFactory.TSSLTransportParameters)this.params);
            }
            catch (SocketException ignored) {
                // empty catch block
            }
            TBinaryProtocol protocol = new TBinaryProtocol(receiverTransport);
            return new ThriftSecureEventTransmissionService.Client((TProtocol)protocol);
        }
        try {
            X509TrustManager easyTrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            String[] hostNameAndPort = keyElements[3].split(":");
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{easyTrustManager}, null);
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme httpsScheme = new Scheme("https", (SocketFactory)sf, Integer.parseInt(hostNameAndPort[1]));
            DefaultHttpClient client = new DefaultHttpClient();
            client.getConnectionManager().getSchemeRegistry().register(httpsScheme);
            THttpClient tclient = new THttpClient("https://" + keyElements[3] + "/thriftAuthenticator", (HttpClient)client);
            TCompactProtocol protocol = new TCompactProtocol((TTransport)tclient);
            ThriftSecureEventTransmissionService.Client authClient = new ThriftSecureEventTransmissionService.Client((TProtocol)protocol);
            tclient.open();
            return authClient;
        }
        catch (Exception e) {
            throw new AgentSecurityException("Cannot create Secure client for " + keyElements[3], e);
        }
    }

    public boolean validateObject(Object key, Object obj) {
        ThriftSecureEventTransmissionService.Client client = (ThriftSecureEventTransmissionService.Client)obj;
        return client.getOutputProtocol().getTransport().isOpen();
    }
}

