/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandUtils {
    private static final Log log = LogFactory.getLog(CommandUtils.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static String executeCommand(String command) throws IOException {
        String line;
        Runtime r = Runtime.getRuntime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("command = " + command));
        }
        Process p = r.exec(command);
        StringBuilder output = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = in.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("output = " + line));
            }
            output.append(line).append(NEW_LINE);
        }
        StringBuilder errors = new StringBuilder();
        BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = error.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("error = " + line));
            }
            errors.append(line).append(NEW_LINE);
        }
        if (errors.length() > 0) {
            throw new RuntimeException("Command execution failed: " + NEW_LINE + errors.toString());
        }
        return output.toString();
    }

    public static String executeCommand(String[] command) throws IOException {
        String line;
        Runtime r = Runtime.getRuntime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("command = " + command));
        }
        Process p = r.exec(command);
        StringBuilder output = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = in.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("output = " + line));
            }
            output.append(line).append(NEW_LINE);
        }
        StringBuilder errors = new StringBuilder();
        BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = error.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("error = " + line));
            }
            errors.append(line).append(NEW_LINE);
        }
        if (errors.length() > 0) {
            throw new RuntimeException("Command execution failed: " + NEW_LINE + errors.toString());
        }
        return output.toString();
    }

    public static String executeCommand(String command, Map<String, String> envParameters) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(command);
        Map<String, String> env = pb.environment();
        env.putAll(envParameters);
        Process p = pb.start();
        StringBuilder output = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = in.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("output = " + line));
            }
            output.append(line).append(NEW_LINE);
        }
        StringBuilder errors = new StringBuilder();
        BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = error.readLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("error = " + line));
            }
            errors.append(line).append(NEW_LINE);
        }
        if (errors.length() > 0) {
            throw new RuntimeException("Command execution failed: " + NEW_LINE + errors.toString());
        }
        return output.toString();
    }
}

