/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher.wso2.cep;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.InFlightRequestPublisher;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class WSO2CEPInFlightRequestPublisher
extends InFlightRequestPublisher {
    private static final Log log = LogFactory.getLog(WSO2CEPInFlightRequestPublisher.class);
    private static volatile WSO2CEPInFlightRequestPublisher wso2CEPInFlightRequestPublisher;
    private static final String DATA_STREAM_NAME = "in_flight_requests";
    private static final String VERSION = "1.0.0";
    private static final String CEP_THRIFT_CLIENT_NAME = "cep";

    private WSO2CEPInFlightRequestPublisher() {
        super(WSO2CEPInFlightRequestPublisher.createStreamDefinition(), CEP_THRIFT_CLIENT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WSO2CEPInFlightRequestPublisher getInstance() {
        if (wso2CEPInFlightRequestPublisher != null) return wso2CEPInFlightRequestPublisher;
        Class<WSO2CEPInFlightRequestPublisher> clazz = WSO2CEPInFlightRequestPublisher.class;
        synchronized (WSO2CEPInFlightRequestPublisher.class) {
            if (wso2CEPInFlightRequestPublisher != null) return wso2CEPInFlightRequestPublisher;
            wso2CEPInFlightRequestPublisher = new WSO2CEPInFlightRequestPublisher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return wso2CEPInFlightRequestPublisher;
        }
    }

    private static StreamDefinition createStreamDefinition() {
        try {
            StreamDefinition streamDefinition = new StreamDefinition(DATA_STREAM_NAME, VERSION);
            streamDefinition.setNickName("lb stats");
            streamDefinition.setDescription("lb stats");
            ArrayList<Attribute> payloadData = new ArrayList<Attribute>();
            payloadData.add(new Attribute("cluster_id", AttributeType.STRING));
            payloadData.add(new Attribute("cluster_instance_id", AttributeType.STRING));
            payloadData.add(new Attribute("network_partition_id", AttributeType.STRING));
            payloadData.add(new Attribute("in_flight_request_count", AttributeType.DOUBLE));
            streamDefinition.setPayloadData(payloadData);
            return streamDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create stream definition", e);
        }
    }

    @Override
    public void publish(String clusterId, String clusterInstanceId, String networkPartitionId, int inFlightRequestCount) {
        ArrayList<Object> payload = new ArrayList<Object>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Publishing health statistics: [cluster] %s [cluster-instance] %s [network-partition] %s [in-flight-request-count] %d", clusterId, clusterInstanceId, networkPartitionId, inFlightRequestCount));
        }
        payload.add(clusterId);
        payload.add(clusterInstanceId);
        payload.add(networkPartitionId);
        payload.add(Double.valueOf(inFlightRequestCount));
        this.publish(payload.toArray());
    }
}

