/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.stratos.common.statistics.publisher.ThriftClientConfigParser;
import org.apache.stratos.common.statistics.publisher.ThriftClientInfo;

public class ThriftClientConfig {
    public static final String THRIFT_CLIENT_CONFIG_FILE_PATH = "thrift.client.config.file.path";
    public static final String CEP_THRIFT_CLIENT_NAME = "cep";
    public static final String DAS_THRIFT_CLIENT_NAME = "das";
    private static volatile ThriftClientConfig instance;
    private List<ThriftClientInfo> cepThriftClientInfo;
    private List<ThriftClientInfo> dasThriftClientInfo;

    ThriftClientConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThriftClientConfig getInstance() {
        if (instance != null) return instance;
        Class<ThriftClientConfig> clazz = ThriftClientConfig.class;
        synchronized (ThriftClientConfig.class) {
            if (instance != null) return instance;
            String configFilePath = System.getProperty(THRIFT_CLIENT_CONFIG_FILE_PATH);
            if (StringUtils.isBlank((String)configFilePath)) {
                throw new RuntimeException(String.format("Thrift client configuration file path system property is not set: %s", THRIFT_CLIENT_CONFIG_FILE_PATH));
            }
            instance = ThriftClientConfigParser.parse(configFilePath);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<ThriftClientInfo> getThriftClientInfo(String thriftClientName) {
        if (CEP_THRIFT_CLIENT_NAME.equals(thriftClientName)) {
            return this.cepThriftClientInfo;
        }
        if (DAS_THRIFT_CLIENT_NAME.equals(thriftClientName)) {
            return this.dasThriftClientInfo;
        }
        return null;
    }

    public void setDASThriftClientInfo(List<ThriftClientInfo> thriftClientInfo) {
        this.dasThriftClientInfo = thriftClientInfo;
    }

    public void setCEPThriftClientInfo(List<ThriftClientInfo> thriftClientInfo) {
        this.cepThriftClientInfo = thriftClientInfo;
    }
}

