/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.axiom.util.UIDGeneratorImpl;

public final class UIDGenerator {
    private static final ThreadLocal impl = new ThreadLocal(){

        protected Object initialValue() {
            return new UIDGeneratorImpl();
        }
    };

    private UIDGenerator() {
    }

    public static String generateContentId() {
        StringBuilder buffer = new StringBuilder();
        ((UIDGeneratorImpl)impl.get()).generateHex(buffer);
        buffer.append("@apache.org");
        return buffer.toString();
    }

    public static String generateMimeBoundary() {
        StringBuilder buffer = new StringBuilder("MIMEBoundary_");
        ((UIDGeneratorImpl)impl.get()).generateHex(buffer);
        return buffer.toString();
    }

    public static String generateUID() {
        StringBuilder buffer = new StringBuilder(48);
        ((UIDGeneratorImpl)impl.get()).generateHex(buffer);
        return buffer.toString();
    }

    public static String generateURNString() {
        return "urn:uuid:" + UUID.randomUUID();
    }

    public static URI generateURN() {
        try {
            return new URI(UIDGenerator.generateURNString());
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }
}

