/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import java.util.concurrent.ThreadFactory;

public abstract class AbstractExecutorThreadFactory
implements ThreadFactory {
    protected final ClassLoader classLoader;
    protected final ThreadGroup threadGroup;

    public AbstractExecutorThreadFactory(ThreadGroup threadGroup, ClassLoader classLoader) {
        this.threadGroup = threadGroup;
        this.classLoader = classLoader;
    }

    @Override
    public final Thread newThread(Runnable r) {
        Thread t = this.createThread(r);
        ClassLoader cl = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        t.setContextClassLoader(cl);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    protected abstract Thread createThread(Runnable var1);
}

