/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.utils.LogWriter;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.message.Message;
import org.wso2.carbon.registry.synchronization.message.MessageCode;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    public static final int RADIX = 16;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_IGNORE_CONFLICTS = "ignoreConflicts";
    private static final String ATTR_IS_COLLECTION = "isCollection";
    private static final String ATTR_STATUS = "status";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KEY = "key";
    private static final String ELEM_RESOURCE = "resource";
    private static final String ELEM_MEDIA_TYPE = "mediaType";
    private static final String ELEM_CREATOR = "creator";
    private static final String ELEM_CREATED_TIME = "createdTime";
    private static final String ELEM_LAST_UPDATER = "lastUpdater";
    private static final String ELEM_LAST_MODIFIED = "lastModified";
    private static final String ELEM_DESCRIPTION = "description";
    private static final String ELEM_UUID = "uuid";
    private static final String ELEM_PROPERTIES = "properties";
    private static final String ELEM_COMMENTS = "comments";
    private static final String ELEM_TAGGINGS = "taggings";
    private static final String ELEM_RATINGS = "ratings";
    private static final String ELEM_VERSION = "version";
    private static final String ELEM_ASSOCIATIONS = "associations";
    private static final String ELEM_CONTENT = "content";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_COMMENT = "comment";
    private static final String ELEM_USER = "user";
    private static final String ELEM_TEXT = "text";
    private static final String ELEM_TAGGING = "tagging";
    private static final String ELEM_DATE = "date";
    private static final String ELEM_TAG_NAME = "tagName";
    private static final String ELEM_RATING = "rating";
    private static final String ELEM_RATE = "rate";
    private static final String ELEM_ASSOCIATION = "association";
    private static final String ELEM_SOURCE = "source";
    private static final String ELEM_DESTINATION = "destination";
    private static final String ELEM_TYPE = "type";
    private static final String ELEM_CHILDREN = "children";
    private static final String REGISTRY_CONTEXT = "/registry";
    private static final String FILE_PATH = "file path: ";
    private static final String META_FILE_NAME = "meta file name: ";
    private static final String FILE_NAME = "file name: ";
    private static final List<String> SERIALIZABLE_ELEMENTS = Arrays.asList("mediaType", "creator", "createdTime", "lastUpdater", "lastModified", "description", "properties", "comments", "taggings", "ratings", "version", "associations");

    private Utils() {
    }

    public static void writeMetaElement(XMLStreamWriter xmlWriter, OMElement metaElement) throws XMLStreamException {
        String ignoreConflicts;
        xmlWriter.writeStartElement(ELEM_RESOURCE);
        String name = metaElement.getAttributeValue(new QName(ATTR_NAME));
        xmlWriter.writeAttribute(ATTR_NAME, name);
        String status = metaElement.getAttributeValue(new QName(ATTR_STATUS));
        if (status != null) {
            xmlWriter.writeAttribute(ATTR_STATUS, status);
        }
        if ((ignoreConflicts = metaElement.getAttributeValue(new QName(ATTR_IGNORE_CONFLICTS))) != null) {
            xmlWriter.writeAttribute(ATTR_IGNORE_CONFLICTS, ignoreConflicts);
        }
        String isCollectionStr = metaElement.getAttributeValue(new QName(ATTR_IS_COLLECTION));
        xmlWriter.writeAttribute(ATTR_IS_COLLECTION, isCollectionStr);
        Iterator childrenIt = metaElement.getChildren();
        while (childrenIt.hasNext()) {
            OMElement childElement;
            String childName;
            Object childObj = childrenIt.next();
            if (!(childObj instanceof OMElement) || !SERIALIZABLE_ELEMENTS.contains(childName = (childElement = (OMElement)childObj).getLocalName())) continue;
            childElement.serialize(xmlWriter);
        }
    }

    public static OMElement readMetaElement(XMLStreamReader xmlReader) throws SynchronizationException, XMLStreamException {
        try {
            while (!xmlReader.isStartElement() && xmlReader.hasNext()) {
                xmlReader.next();
            }
            if (!xmlReader.hasNext()) {
                return null;
            }
            if (!xmlReader.getLocalName().equals(ELEM_RESOURCE)) {
                throw new SynchronizationException(MessageCode.INVALID_DUMP_CREATE_META_FILE);
            }
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement root = factory.createOMElement(new QName(ELEM_RESOURCE));
            String resourceName = xmlReader.getAttributeValue(null, ATTR_NAME);
            String isCollectionString = xmlReader.getAttributeValue(null, ATTR_IS_COLLECTION);
            root.addAttribute(ATTR_NAME, resourceName, null);
            root.addAttribute(ATTR_IS_COLLECTION, isCollectionString, null);
            do {
                xmlReader.next();
            } while (!xmlReader.isStartElement() && xmlReader.hasNext());
            while (xmlReader.hasNext()) {
                OMElement dateElement;
                OMElement userElement;
                String text;
                OMElement description;
                String text2;
                String localName = xmlReader.getLocalName();
                if (localName.equals(ELEM_VERSION)) {
                    text2 = xmlReader.getElementText();
                    OMElement versionElement = factory.createOMElement(new QName(ELEM_VERSION));
                    if (text2 != null) {
                        versionElement.setText(text2);
                    }
                    root.addChild((OMNode)versionElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_MEDIA_TYPE)) {
                    text2 = xmlReader.getElementText();
                    OMElement mediaTypeElement = factory.createOMElement(new QName(ELEM_MEDIA_TYPE));
                    if (text2 != null) {
                        mediaTypeElement.setText(text2);
                    }
                    root.addChild((OMNode)mediaTypeElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_CREATOR)) {
                    text2 = xmlReader.getElementText();
                    OMElement creatorElement = factory.createOMElement(new QName(ELEM_CREATOR));
                    if (text2 != null) {
                        creatorElement.setText(text2);
                    }
                    root.addChild((OMNode)creatorElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_CREATED_TIME)) {
                    text2 = xmlReader.getElementText();
                    OMElement createdTimeElement = factory.createOMElement(new QName(ELEM_CREATED_TIME));
                    if (text2 != null) {
                        createdTimeElement.setText(text2);
                    }
                    root.addChild((OMNode)createdTimeElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_CONTENT)) {
                    text2 = xmlReader.getElementText();
                    OMElement contentElement = factory.createOMElement(new QName(ELEM_CONTENT));
                    if (text2 != null) {
                        contentElement.setText(text2);
                    }
                    root.addChild((OMNode)contentElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_LAST_UPDATER)) {
                    text2 = xmlReader.getElementText();
                    OMElement lastUpdaterElement = factory.createOMElement(new QName(ELEM_LAST_UPDATER));
                    if (text2 != null) {
                        lastUpdaterElement.setText(text2);
                    }
                    root.addChild((OMNode)lastUpdaterElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_LAST_MODIFIED)) {
                    text2 = xmlReader.getElementText();
                    OMElement lastModifiedElement = factory.createOMElement(new QName(ELEM_LAST_MODIFIED));
                    if (text2 != null) {
                        lastModifiedElement.setText(text2);
                    }
                    root.addChild((OMNode)lastModifiedElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_DESCRIPTION)) {
                    text2 = xmlReader.getElementText();
                    description = factory.createOMElement(new QName(ELEM_DESCRIPTION));
                    if (text2 != null) {
                        description.setText(text2);
                    }
                    root.addChild((OMNode)description);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_UUID)) {
                    text2 = xmlReader.getElementText();
                    description = factory.createOMElement(new QName(ELEM_UUID));
                    if (text2 != null) {
                        description.setText(text2);
                    }
                    root.addChild((OMNode)description);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                } else if (localName.equals(ELEM_PROPERTIES)) {
                    OMElement properties = factory.createOMElement(new QName(ELEM_PROPERTIES));
                    root.addChild((OMNode)properties);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                    while (xmlReader.hasNext() && xmlReader.getLocalName().equals(ELEM_PROPERTY)) {
                        String key = xmlReader.getAttributeValue(null, ATTR_KEY);
                        text = xmlReader.getElementText();
                        OMElement property = factory.createOMElement(new QName(ELEM_PROPERTY));
                        property.addAttribute(ATTR_KEY, key, null);
                        properties.addChild((OMNode)property);
                        if (text.equals("")) {
                            text = null;
                        }
                        if (text != null) {
                            property.setText(text);
                        }
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                    }
                } else if (localName.equals(ELEM_COMMENTS)) {
                    OMElement commentsElement = factory.createOMElement(new QName(ELEM_COMMENTS));
                    root.addChild((OMNode)commentsElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                    while (xmlReader.hasNext() && xmlReader.getLocalName().equals(ELEM_COMMENT)) {
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                        localName = xmlReader.getLocalName();
                        OMElement commentElement = factory.createOMElement(new QName(ELEM_COMMENT));
                        commentsElement.addChild((OMNode)commentElement);
                        while (xmlReader.hasNext() && (localName.equals(ELEM_USER) || localName.equals(ELEM_TEXT))) {
                            if (localName.equals(ELEM_USER)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    userElement = factory.createOMElement(new QName(ELEM_USER));
                                    userElement.setText(text);
                                    commentElement.addChild((OMNode)userElement);
                                }
                            } else if (localName.equals(ELEM_TEXT) && (text = xmlReader.getElementText()) != null) {
                                OMElement textElement = factory.createOMElement(new QName(ELEM_TEXT));
                                textElement.setText(text);
                                commentElement.addChild((OMNode)textElement);
                            }
                            do {
                                xmlReader.next();
                            } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                            if (!xmlReader.hasNext()) continue;
                            localName = xmlReader.getLocalName();
                        }
                    }
                } else if (localName.equals(ELEM_TAGGINGS)) {
                    OMElement taggingsElement = factory.createOMElement(new QName(ELEM_TAGGINGS));
                    root.addChild((OMNode)taggingsElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                    while (xmlReader.hasNext() && xmlReader.getLocalName().equals(ELEM_TAGGING)) {
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                        localName = xmlReader.getLocalName();
                        OMElement taggingElement = factory.createOMElement(new QName(ELEM_TAGGING));
                        taggingsElement.addChild((OMNode)taggingElement);
                        while (xmlReader.hasNext() && (localName.equals(ELEM_USER) || localName.equals(ELEM_DATE) || localName.equals(ELEM_TAG_NAME))) {
                            if (localName.equals(ELEM_USER)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    userElement = factory.createOMElement(new QName(ELEM_USER));
                                    userElement.setText(text);
                                    taggingElement.addChild((OMNode)userElement);
                                }
                            } else if (localName.equals(ELEM_DATE)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    dateElement = factory.createOMElement(new QName(ELEM_DATE));
                                    dateElement.setText(text);
                                    taggingElement.addChild((OMNode)dateElement);
                                }
                            } else if (localName.equals(ELEM_TAG_NAME) && (text = xmlReader.getElementText()) != null) {
                                OMElement tagNameElement = factory.createOMElement(new QName(ELEM_TAG_NAME));
                                tagNameElement.setText(text);
                                taggingElement.addChild((OMNode)tagNameElement);
                            }
                            do {
                                xmlReader.next();
                            } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                            if (!xmlReader.hasNext()) continue;
                            localName = xmlReader.getLocalName();
                        }
                    }
                } else if (localName.equals(ELEM_RATINGS)) {
                    OMElement ratingsElement = factory.createOMElement(new QName(ELEM_RATINGS));
                    root.addChild((OMNode)ratingsElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                    while (xmlReader.hasNext() && xmlReader.getLocalName().equals(ELEM_RATING)) {
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
                        localName = xmlReader.getLocalName();
                        OMElement ratingElement = factory.createOMElement(new QName(ELEM_RATING));
                        ratingsElement.addChild((OMNode)ratingElement);
                        while (xmlReader.hasNext() && (localName.equals(ELEM_USER) || localName.equals(ELEM_DATE) || localName.equals(ELEM_RATE))) {
                            if (localName.equals(ELEM_USER)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    userElement = factory.createOMElement(new QName(ELEM_USER));
                                    userElement.setText(text);
                                    ratingElement.addChild((OMNode)userElement);
                                }
                            } else if (localName.equals(ELEM_DATE)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    dateElement = factory.createOMElement(new QName(ELEM_DATE));
                                    dateElement.setText(text);
                                    ratingElement.addChild((OMNode)dateElement);
                                }
                            } else if (localName.equals(ELEM_RATE) && (text = xmlReader.getElementText()) != null) {
                                OMElement rateElement = factory.createOMElement(new QName(ELEM_RATE));
                                rateElement.setText(text);
                                ratingElement.addChild((OMNode)rateElement);
                            }
                            do {
                                xmlReader.next();
                            } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                            if (!xmlReader.hasNext()) continue;
                            localName = xmlReader.getLocalName();
                        }
                    }
                } else {
                    if (!localName.equals(ELEM_ASSOCIATIONS)) {
                        if (localName.equals(ELEM_CHILDREN) || !localName.equals(ELEM_RESOURCE)) break;
                        break;
                    }
                    OMElement associationsElement = factory.createOMElement(new QName(ELEM_ASSOCIATIONS));
                    root.addChild((OMNode)associationsElement);
                    do {
                        xmlReader.next();
                    } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                    while (xmlReader.hasNext() && xmlReader.getLocalName().equals(ELEM_ASSOCIATION)) {
                        do {
                            xmlReader.next();
                        } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                        localName = xmlReader.getLocalName();
                        OMElement associationElement = factory.createOMElement(new QName(ELEM_ASSOCIATION));
                        associationsElement.addChild((OMNode)associationElement);
                        while (xmlReader.hasNext() && (localName.equals(ELEM_SOURCE) || localName.equals(ELEM_DESTINATION) || localName.equals(ELEM_TYPE))) {
                            if (localName.equals(ELEM_SOURCE)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    OMElement sourceElement = factory.createOMElement(new QName(ELEM_SOURCE));
                                    sourceElement.setText(text);
                                    associationElement.addChild((OMNode)sourceElement);
                                }
                            } else if (localName.equals(ELEM_DESTINATION)) {
                                text = xmlReader.getElementText();
                                if (text != null) {
                                    OMElement destinationElement = factory.createOMElement(new QName(ELEM_DESTINATION));
                                    destinationElement.setText(text);
                                    associationElement.addChild((OMNode)destinationElement);
                                }
                            } else if (localName.equals(ELEM_TYPE) && (text = xmlReader.getElementText()) != null) {
                                OMElement typeElement = factory.createOMElement(new QName(ELEM_TYPE));
                                typeElement.setText(text);
                                associationElement.addChild((OMNode)typeElement);
                            }
                            do {
                                xmlReader.next();
                            } while (!xmlReader.isStartElement() && xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)));
                            if (!xmlReader.hasNext()) continue;
                            localName = xmlReader.getLocalName();
                        }
                    }
                }
                if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(ELEM_RESOURCE)) continue;
                break;
            }
            return root;
        }
        catch (XMLStreamException e) {
            throw new SynchronizationException(MessageCode.ERROR_IN_READING_STREAM_TO_CREATE_META_FILE, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMetaFile(String fileName, OMElement metaData) throws SynchronizationException {
        try {
            File metaDir;
            File file = new File(fileName);
            String metaDirName = file.getAbsoluteFile().getParent();
            if (metaDirName != null && !(metaDir = new File(metaDirName)).exists() && !metaDir.mkdir()) {
                throw new SynchronizationException(MessageCode.ERROR_CREATING_META_FILE, new String[]{FILE_NAME + fileName});
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new SynchronizationException(MessageCode.FILE_ALREADY_EXISTS, new String[]{FILE_NAME + fileName});
            }
            FileOutputStream fileOut = null;
            try {
                fileOut = new FileOutputStream(file, false);
                metaData.serialize((OutputStream)fileOut);
            }
            finally {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
        }
        catch (IOException e) {
            throw new SynchronizationException(MessageCode.ERROR_CREATING_META_FILE, e, new String[]{FILE_NAME + fileName});
        }
        catch (XMLStreamException e) {
            throw new SynchronizationException(MessageCode.ERROR_WRITING_TO_META_FILE, e, new String[]{FILE_NAME + fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMetaFile(String fileName, OMElement metaData) throws SynchronizationException {
        try {
            File file = new File(fileName);
            FileOutputStream fileOut = null;
            try {
                fileOut = new FileOutputStream(file, false);
                metaData.serialize((OutputStream)fileOut);
            }
            finally {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
        }
        catch (IOException e) {
            throw new SynchronizationException(MessageCode.ERROR_CREATING_META_FILE, e, new String[]{FILE_NAME + fileName});
        }
        catch (XMLStreamException e) {
            throw new SynchronizationException(MessageCode.ERROR_WRITING_TO_META_FILE, e, new String[]{FILE_NAME + fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceUpdated(String metaFilePath, OMElement metaElement) {
        File file = new File(metaFilePath);
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                OMElement fileMetaElement = Utils.readMetaElement(xmlReader);
                if (Utils.getLastModified(metaElement) == Utils.getLastModified(fileMetaElement)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close the stream", (Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    private static long getLastModified(OMElement metadata) {
        return Long.parseLong(((OMElement)metadata.getChildrenWithLocalName(ELEM_LAST_MODIFIED).next()).getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws SynchronizationException {
        FileInputStream is = null;
        try {
            int offset;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new SynchronizationException(MessageCode.FILE_TO_READ_IS_NOT_FOUND, e, new String[]{FILE_NAME + file.getName()});
            }
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new SynchronizationException(MessageCode.FILE_LENGTH_IS_TOO_LARGE, new String[]{FILE_NAME + file.getName(), "file length limit: 2147483647"});
            }
            byte[] bytes = new byte[(int)length];
            try {
                int numRead;
                for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
            }
            catch (IOException e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_READING, e, new String[]{FILE_NAME + file.getName()});
            }
            if (offset < bytes.length) {
                throw new SynchronizationException(MessageCode.ERROR_IN_COMPLETELY_READING, new String[]{FILE_NAME + file.getName()});
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public static OMElement getMetaOMElement(String filePath) throws SynchronizationException {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String fileName = file.getName();
        String metaFilePath = Utils.getMetaFilePath(file);
        File metaFile = new File(metaFilePath);
        if (!metaFile.exists()) {
            return null;
        }
        return Utils.getOMElementFromMetaFile(metaFilePath);
    }

    public static OMElement getOMElementFromMetaFile(String metaFilePath) throws SynchronizationException {
        File metaFile = new File(metaFilePath);
        OMElement element = null;
        FileInputStream directoryMetaFileStream = null;
        if (metaFile.exists()) {
            try {
                directoryMetaFileStream = new FileInputStream(metaFilePath);
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(directoryMetaFileStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                element = builder.getDocumentElement().cloneOMElement();
                try {
                    directoryMetaFileStream.close();
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_CLOSING_META_FILE_STREAM, e, new String[]{META_FILE_NAME + metaFilePath});
                }
            }
            catch (IOException e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_READING_META_FILE, e, new String[]{META_FILE_NAME + metaFilePath});
            }
            catch (XMLStreamException e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_READING_META_FILE_STREAM, e, new String[]{META_FILE_NAME + metaFilePath});
            }
            finally {
                if (directoryMetaFileStream != null) {
                    try {
                        directoryMetaFileStream.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return element;
    }

    public static OMElement createDefaultMetaFile(boolean isCollection, String path, String username) throws SynchronizationException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement root = factory.createOMElement(new QName(ELEM_RESOURCE));
        root.addAttribute(ATTR_PATH, path, null);
        String resourceName = RegistryUtils.getResourceName(path);
        root.addAttribute(ATTR_NAME, resourceName, null);
        root.addAttribute(ATTR_IS_COLLECTION, isCollection ? "true" : "false", null);
        String mediaType = "unknown";
        int lastIndex = path.lastIndexOf(46);
        if (lastIndex > 0) {
            mediaType = path.substring(lastIndex + 1);
        }
        OMElement child = factory.createOMElement(new QName(ELEM_MEDIA_TYPE));
        child.setText(mediaType);
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_CREATOR));
        child.setText(username);
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_LAST_UPDATER));
        child.setText(username);
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_DESCRIPTION));
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_UUID));
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_VERSION));
        child.setText("0");
        root.addChild((OMNode)child);
        return root;
    }

    public static OMElement updateDefaultAddMetaFile(OMElement root, String path, String username, boolean isDirectory) throws SynchronizationException {
        OMElement child;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        if (!isDirectory && root.getChildrenWithName(new QName(ELEM_MEDIA_TYPE)) == null) {
            String mediaType = "unknown";
            int lastIndex = path.lastIndexOf(46);
            if (lastIndex > 0) {
                mediaType = path.substring(lastIndex + 1);
            }
            child = factory.createOMElement(new QName(ELEM_MEDIA_TYPE));
            child.setText(mediaType);
            root.addChild((OMNode)child);
        }
        child = factory.createOMElement(new QName(ELEM_CREATOR));
        child.setText(username);
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_LAST_UPDATER));
        child.setText(username);
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_DESCRIPTION));
        root.addChild((OMNode)child);
        child = factory.createOMElement(new QName(ELEM_UUID));
        root.addChild((OMNode)child);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File destination) throws SynchronizationException {
        try {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int len;
                in = new FileInputStream(source);
                out = new FileOutputStream(destination);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SynchronizationException(MessageCode.ERROR_IN_COPYING, e, new String[]{"source: " + source, "target: " + destination});
        }
    }

    public static String getRegistryUrl(String url) {
        if (url.startsWith("/")) {
            return null;
        }
        if (url.indexOf(REGISTRY_CONTEXT) > 0) {
            return url.substring(0, url.lastIndexOf(REGISTRY_CONTEXT) + REGISTRY_CONTEXT.length());
        }
        return null;
    }

    public static String getPath(String url) {
        if (url.startsWith("/")) {
            return url;
        }
        if (url.indexOf(REGISTRY_CONTEXT) > 0) {
            return url.substring(url.lastIndexOf(REGISTRY_CONTEXT) + REGISTRY_CONTEXT.length());
        }
        return null;
    }

    public static String encodeResourceName(String resourceName) throws SynchronizationException {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(resourceName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SynchronizationException(MessageCode.ERROR_ENCODING_RESOURCE_NAME, e, new String[]{"resource name: " + resourceName});
        }
        return encodedName;
    }

    public static String decodeFilename(String path) throws SynchronizationException {
        String decodedName;
        try {
            decodedName = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SynchronizationException(MessageCode.ERROR_DECODING_PATH, e, new String[]{"path: " + path});
        }
        return decodedName;
    }

    public static boolean confirmDelete(File file, File metaFile, UserInputCallback callback) throws SynchronizationException {
        boolean inputCode;
        String filePath = file.getAbsolutePath();
        boolean isDirectory = file.isDirectory();
        boolean sameContent = false;
        if (!isDirectory && metaFile.exists()) {
            OMElement metaElement;
            try {
                metaElement = new StAXOMBuilder((InputStream)new FileInputStream(metaFile)).getDocumentElement();
            }
            catch (Exception e) {
                throw new SynchronizationException(MessageCode.RESOURCE_METADATA_CORRUPTED, (Throwable)e);
            }
            OMAttribute md5Attribute = metaElement.getAttribute(new QName("md5"));
            String metaFileMD5 = null;
            if (md5Attribute != null) {
                metaFileMD5 = md5Attribute.getAttributeValue();
            }
            String fileMD5 = Utils.getMD5(file);
            sameContent = fileMD5.equals(metaFileMD5);
        }
        if (!sameContent && !(inputCode = callback == null ? true : (file.isDirectory() ? callback.getConfirmation(new Message(MessageCode.DIRECTORY_DELETE_CONFIRMATION, new String[]{FILE_PATH + filePath}), "delete") : callback.getConfirmation(new Message(MessageCode.FILE_DELETE_CONFIRMATION, new String[]{FILE_PATH + filePath}), "delete")))) {
            return false;
        }
        boolean deleted = Utils.deleteFile(file);
        if (!deleted) {
            throw new SynchronizationException(MessageCode.ERROR_IN_DELETING, new String[]{FILE_PATH + filePath});
        }
        if (!isDirectory && !(deleted = Utils.deleteFile(metaFile))) {
            throw new SynchronizationException(MessageCode.ERROR_IN_DELETING, new String[]{FILE_PATH + metaFile.getAbsolutePath()});
        }
        return true;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            String[] children;
            for (String child : children = file.list()) {
                boolean success = Utils.deleteFile(new File(file, child));
                if (success) continue;
                return false;
            }
        }
        return FileUtils.deleteQuietly((File)file);
    }

    public static List<String> cleanUpDirectory(File directory, List<String> filesToPreserve) {
        LinkedList<String> filesToClean = new LinkedList<String>();
        if (directory.isDirectory()) {
            String[] children;
            for (String child : children = directory.list()) {
                File file = new File(directory, child);
                String absoluteFilePath = file.getAbsolutePath();
                if (filesToPreserve.contains(absoluteFilePath)) continue;
                filesToClean.add(absoluteFilePath);
            }
        }
        return filesToClean;
    }

    public static String getMD5(byte[] content) {
        MessageDigest m;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            return null;
        }
        m.update(content, 0, content.length);
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static String getMD5(File file) throws SynchronizationException {
        return Utils.getMD5(Utils.getBytesFromFile(file));
    }

    public static boolean contentChanged(File file) throws SynchronizationException {
        return Utils.contentChanged(file, true);
    }

    private static boolean contentChanged(File file, boolean isParent) throws SynchronizationException {
        if (!file.exists()) {
            throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_CHECK_IN);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                if (isParent) {
                    throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_CHECK_IN);
                }
                return true;
            }
            File metaFile = new File(file.getPath() + File.separator + ".meta");
            File[] metaFiles = metaFile.listFiles();
            if (metaFiles == null || metaFiles.length == 0) {
                return true;
            }
            int childFiles = 0;
            for (File child : files) {
                if (child.isDirectory()) continue;
                ++childFiles;
            }
            if (metaFiles.length - 1 != childFiles) {
                return true;
            }
            for (File child : files) {
                if (child.getPath().endsWith(".meta") || !Utils.contentChanged(child, false)) continue;
                return true;
            }
            return false;
        }
        return Utils.fileContentChanged(file);
    }

    public static boolean fileContentChanged(File file) throws SynchronizationException {
        String parentDirName = file.getAbsoluteFile().getParent();
        String name = file.getName();
        String metaFilePath = parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(name) + ".xml";
        String currentMD5 = Utils.getMD5(Utils.getBytesFromFile(file));
        OMElement metaFileElement = Utils.getOMElementFromMetaFile(metaFilePath);
        String metaFileMD5 = null;
        if (metaFileElement != null) {
            metaFileMD5 = metaFileElement.getAttributeValue(new QName("md5"));
        }
        return metaFileMD5 == null || !metaFileMD5.equals(currentMD5);
    }

    public static void cleanEmbeddedRegistry() {
        LogWriter logWriter;
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        if (registryContext != null && (logWriter = registryContext.getLogWriter()) != null) {
            logWriter.interrupt();
        }
    }

    public static String getMetaFilePath(String path) throws SynchronizationException {
        File f = new File(path);
        return Utils.getMetaFilePath(f);
    }

    public static String getMetaFilePath(File f) throws SynchronizationException {
        String absPath = f.getAbsolutePath();
        if (f.isDirectory()) {
            return absPath + File.separator + ".meta" + File.separator + "~" + ".xml";
        }
        return absPath.substring(0, absPath.lastIndexOf(File.separator)) + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(f.getName()) + ".xml";
    }

    public static void addResource(String path) throws SynchronizationException {
        String pathAttribute;
        String registryUrl = null;
        String metaFile = Utils.getMetaFilePath(path);
        File file = new File(metaFile);
        try {
            OMElement resourceElement = new StAXOMBuilder((InputStream)new FileInputStream(file)).getDocumentElement();
            pathAttribute = resourceElement.getAttribute(new QName(ATTR_PATH)).getAttributeValue();
            OMAttribute registryUrlAttr = resourceElement.getAttribute(new QName("registryUrl"));
            if (registryUrlAttr != null) {
                registryUrl = registryUrlAttr.getAttributeValue();
            }
        }
        catch (FileNotFoundException e) {
            throw new SynchronizationException(MessageCode.CURRENT_COLLECTION_NOT_UNDER_REGISTRY_CONTROL);
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.RESOURCE_METADATA_CORRUPTED);
        }
        Utils.addResourceMetadataRecursively(path, pathAttribute, registryUrl, true);
    }

    private static void addResourceMetadataRecursively(String path, String parentRegistryPath, String registryUrl, boolean root) throws SynchronizationException {
        File file = new File(path);
        String registryPath = parentRegistryPath + File.separator + file.getName();
        if (file.isDirectory()) {
            String metaFilePath = path + File.separator + ".meta" + File.separator + "~" + ".xml";
            Utils.addMetadata(metaFilePath, file.getName(), true, registryPath, registryUrl, root);
            for (String fileName : file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return !".meta".equals(s);
                }
            })) {
                Utils.addResourceMetadataRecursively(path + File.separator + fileName, registryPath, registryUrl, false);
            }
        } else {
            String parentDirName = file.getParent();
            String metaFilePath = parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(file.getName()) + ".xml";
            Utils.addMetadata(metaFilePath, file.getName(), false, registryPath, registryUrl, root);
        }
    }

    private static void addMetadata(String metaFilePath, String fileName, boolean isCollection, String registryPath, String registryUrl, boolean root) throws SynchronizationException {
        OutputStreamWriter writer = null;
        File file = new File(metaFilePath);
        if (file.exists()) {
            return;
        }
        try {
            File metaDir = new File(file.getParent());
            metaDir.mkdirs();
            file.createNewFile();
            writer = new FileWriter(file);
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xof.createXMLStreamWriter(writer);
            xmlWriter.writeStartElement(ELEM_RESOURCE);
            xmlWriter.writeAttribute(ATTR_NAME, fileName);
            xmlWriter.writeAttribute(ATTR_IS_COLLECTION, String.valueOf(isCollection));
            xmlWriter.writeAttribute(ATTR_PATH, registryPath);
            if (registryUrl != null) {
                xmlWriter.writeAttribute("registryUrl", registryUrl);
            }
            xmlWriter.writeAttribute(ATTR_STATUS, "added");
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.ERROR_IN_ADDING_METADATA);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the stream", (Throwable)e);
                }
            }
        }
    }

    public static void setResourcesDelete(String dirPath) throws SynchronizationException {
        if (dirPath.endsWith(File.separator)) {
            dirPath = dirPath.substring(0, dirPath.length() - 1);
        }
        Utils.findAndSetResourcesDeleteRecursively(dirPath);
    }

    private static void findAndSetResourcesDeleteRecursively(String dirPath) throws SynchronizationException {
        String[] childFiles;
        String[] metaFiles;
        String metaDirPath = dirPath + File.separator + ".meta";
        File file = new File(metaDirPath);
        for (String metaFilePath : metaFiles = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return !s.equals("~.xml");
            }
        })) {
            String fileName = metaFilePath.substring(1, metaFilePath.length() - 4);
            String filePath = dirPath + File.separator + fileName;
            File resourceFile = new File(Utils.decodeFilename(filePath));
            if (resourceFile.exists()) continue;
            Utils.setDelete(metaDirPath + File.separator + metaFilePath);
        }
        File dir = new File(dirPath);
        for (String child : childFiles = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return !s.equals(".meta");
            }
        })) {
            String childPath = dirPath + File.separator + child;
            if (!new File(childPath).isDirectory()) continue;
            Utils.findAndSetResourcesDeleteRecursively(childPath);
        }
    }

    private static void setDelete(String metaFilePath) throws SynchronizationException {
        File metaFile = new File(metaFilePath);
        OutputStreamWriter writer = null;
        try {
            OMElement resourceElement = new StAXOMBuilder((InputStream)new FileInputStream(metaFile)).getDocumentElement();
            resourceElement.addAttribute(ATTR_STATUS, "deleted", null);
            writer = new FileWriter(metaFile);
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xof.createXMLStreamWriter(writer);
            resourceElement.serialize(xmlWriter);
            xmlWriter.flush();
        }
        catch (FileNotFoundException e) {
            throw new SynchronizationException(MessageCode.RESOURCE_NOT_UNDER_REGISTRY_CONTROL);
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.RESOURCE_METADATA_CORRUPTED);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the stream", (Throwable)e);
                }
            }
        }
    }
}

