/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.messaging.util;

import java.io.InputStreamReader;
import java.util.List;
import org.wso2.andes.messaging.Address;
import org.wso2.andes.messaging.util.AddressParser;
import org.wso2.andes.messaging.util.ParseError;
import org.wso2.andes.messaging.util.PyPrint;
import org.wso2.andes.messaging.util.Token;

public class JAddr {
    public static final void main(String[] args) throws Exception {
        int n;
        StringBuilder addr = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(System.in);
        char[] buf = new char[1024];
        while ((n = reader.read(buf, 0, buf.length)) >= 0) {
            addr.append(buf, 0, n);
        }
        if ("parse".equals(args[0])) {
            try {
                Address address = Address.parse(addr.toString());
                System.out.println(JAddr.pprint_address(address));
            }
            catch (ParseError e) {
                System.out.println(String.format("ERROR: %s", e.getMessage()));
            }
        } else {
            List<Token> tokens = AddressParser.lex(addr.toString());
            for (Token t : tokens) {
                String value = t.getValue();
                if (value != null) {
                    value = value.replace("\\", "\\\\").replace("\n", "\\n");
                    System.out.println(String.format("%s:%s:%s", t.getType(), t.getPosition(), value));
                    continue;
                }
                System.out.println(String.format("%s:%s", t.getType(), t.getPosition()));
            }
        }
    }

    private static String pprint_address(Address addr) {
        return String.format("NAME: %s\nSUBJECT: %s\nOPTIONS: %s", PyPrint.pprint(addr.getName()), PyPrint.pprint(addr.getSubject()), PyPrint.pprint(addr.getOptions()));
    }
}

