/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.dialect;

import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.compass.gps.device.jdbc.dialect.JdbcDialect;
import org.compass.gps.device.jdbc.mapping.ColumnMapping;
import org.compass.gps.device.jdbc.mapping.VersionColumnMapping;

public class DefaultJdbcDialect
implements JdbcDialect {
    protected Long getIntegerAsLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        int integer = columnMapping.isUsingColumnIndex() ? rs.getInt(columnMapping.getColumnIndex()) : rs.getInt(columnMapping.getColumnName());
        return new Long(integer);
    }

    protected Long getNumericAsLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        if (columnMapping.isUsingColumnIndex()) {
            return new Long(rs.getLong(columnMapping.getColumnIndex()));
        }
        return new Long(rs.getLong(columnMapping.getColumnName()));
    }

    protected Long getLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        if (columnMapping.isUsingColumnIndex()) {
            return (Long)rs.getObject(columnMapping.getColumnIndex());
        }
        return (Long)rs.getObject(columnMapping.getColumnName());
    }

    protected Long getDateAsLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        Date date = null;
        date = columnMapping.isUsingColumnIndex() ? rs.getDate(columnMapping.getColumnIndex()) : rs.getDate(columnMapping.getColumnName());
        return new Long(date.getTime());
    }

    protected Long getTimeAsLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        Time date = null;
        date = columnMapping.isUsingColumnIndex() ? rs.getTime(columnMapping.getColumnIndex()) : rs.getTime(columnMapping.getColumnName());
        return new Long(date.getTime());
    }

    protected Long getTimestampAsLong(ResultSet rs, ColumnMapping columnMapping) throws SQLException {
        Timestamp timestamp = null;
        timestamp = columnMapping.isUsingColumnIndex() ? rs.getTimestamp(columnMapping.getColumnIndex()) : rs.getTimestamp(columnMapping.getColumnName());
        return new Long(timestamp.getTime());
    }

    public Long getVersion(ResultSet rs, VersionColumnMapping versionMapping) throws SQLException {
        Long result = null;
        int sqlType = versionMapping.getSqlType();
        result = sqlType == 4 ? this.getIntegerAsLong(rs, versionMapping) : (sqlType == 91 ? this.getDateAsLong(rs, versionMapping) : (sqlType == 93 ? this.getTimestampAsLong(rs, versionMapping) : (sqlType == 92 ? this.getTimeAsLong(rs, versionMapping) : (sqlType == 2 ? this.getNumericAsLong(rs, versionMapping) : this.getLong(rs, versionMapping)))));
        return result;
    }

    public void setParameter(PreparedStatement ps, int paramIndex, String value) throws SQLException {
        ParameterMetaData metaData = ps.getParameterMetaData();
        int type = metaData.getParameterType(paramIndex);
        if (type == -5) {
            long lValue = Long.parseLong(value);
            ps.setLong(paramIndex, lValue);
        } else if (type == 4) {
            int iValue = Integer.parseInt(value);
            ps.setInt(paramIndex, iValue);
        } else if (type == 5) {
            short iValue = Short.parseShort(value);
            ps.setShort(paramIndex, iValue);
        } else if (type == 12 || type == -1 || type == 1) {
            ps.setString(paramIndex, value);
        } else {
            throw new IllegalArgumentException("Failed to set parameter for type [" + metaData.getParameterTypeName(paramIndex) + "], not supported");
        }
    }

    public String getStringValue(ResultSet rs, ColumnMapping mapping) throws SQLException {
        String value = null;
        value = mapping.isUsingColumnIndex() ? rs.getString(mapping.getColumnIndex()) : rs.getString(mapping.getColumnName());
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }

    public String getStringValue(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }
}

