/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReadSchemaFromURL {
    private static final String SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: ReadSchemaFromURL URL -wsdl");
            return;
        }
        boolean wsdl = false;
        if (args.length == 2) {
            wsdl = true;
        }
        XmlSchemaCollection collection = new XmlSchemaCollection();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(args[0]);
        Element schema = document.getDocumentElement();
        if (wsdl) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    if ("xsd".equals(prefix)) {
                        return ReadSchemaFromURL.SCHEMA_URI;
                    }
                    return null;
                }

                public String getPrefix(String namespaceURI) {
                    if (ReadSchemaFromURL.SCHEMA_URI.equals(namespaceURI)) {
                        return "xsd";
                    }
                    return null;
                }

                public Iterator getPrefixes(String namespaceURI) {
                    ArrayList<String> prefixes = new ArrayList<String>();
                    prefixes.add("xsd");
                    return prefixes.iterator();
                }
            });
            NodeList schemas = (NodeList)xpath.evaluate("//xsd:schema", document, XPathConstants.NODESET);
            for (int x = 0; x < schemas.getLength(); ++x) {
                schema = (Element)schemas.item(x);
                collection.read(schema, args[0]);
            }
        } else {
            collection.read(document, args[0], null);
        }
        System.out.println("Success.");
    }
}

