/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.commons;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeanRegistrar {
    private static final MBeanRegistrar ourInstance = new MBeanRegistrar();
    private static final Log log = LogFactory.getLog(MBeanRegistrar.class);

    public static MBeanRegistrar getInstance() {
        return ourInstance;
    }

    private MBeanRegistrar() {
    }

    public void registerMBean(Object mbeanInstance, String category, String id) {
        this.assertNull(mbeanInstance, "Mbean instance is null");
        this.assertNull(category, "Mbean instance category is null");
        this.assertNull(id, "Mbean instance name is null");
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(this.getObjectName(category, id));
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            log.warn("Error registering a MBean with name ' " + id + " ' and category name ' " + category + "' for JMX management", e);
        }
    }

    public void unRegisterMBean(String category, String id) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objName = new ObjectName(this.getObjectName(category, id));
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
        }
        catch (Exception e) {
            log.warn("Error un-registering a  MBean with name ' " + id + " ' and category name ' " + category + "' for JMX management", e);
        }
    }

    private String getObjectName(String category, String id) {
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.synapse";
        }
        return jmxAgentName + ":Type=" + category + ",Name=" + id;
    }

    private void assertNull(String name, String msg) {
        if (name == null || "".equals(name)) {
            MBeanRegistrar.handleException(msg);
        }
    }

    private void assertNull(Object object, String msg) {
        if (object == null) {
            MBeanRegistrar.handleException(msg);
        }
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecurityException(msg);
    }
}

