/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugObjectOutputStream
implements ObjectStreamConstants,
ObjectOutput {
    private static final Log log = LogFactory.getLog(DebugObjectOutputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectOutput out;

    DebugObjectOutputStream(ObjectOutput out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("--START DebugOutputStream--");
        }
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("--CLOSE DebugOutputStream--");
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start flush()");
        }
        this.out.flush();
        if (log.isDebugEnabled()) {
            log.debug("end flush()");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start write(b, off, len) off=" + off + " len=" + len);
        }
        if (len > 4 && log.isDebugEnabled()) {
            log.debug(" first four bytes = '" + b[off] + "' '" + b[off + 1] + "' '" + b[off + 2] + "' '" + b[off + 3] + "'");
        }
        this.out.write(b, off, len);
        if (log.isDebugEnabled()) {
            log.debug("end write(b, off, len)");
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start write byte[]");
        }
        this.out.write(b);
        if (log.isDebugEnabled()) {
            log.debug("end write(b)");
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start write(int) int=" + b);
        }
        this.out.write(b);
        if (log.isDebugEnabled()) {
            log.debug("end write(int)");
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeBoolean(v) v=" + v);
        }
        this.out.writeBoolean(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeBoolean(v)");
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeByte(v) v=" + v);
        }
        this.out.writeByte(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeByte(v)");
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        log.debug("start writeBytes(s) s=" + s);
        this.out.writeBytes(s);
        log.debug("end writeBytes(s)");
    }

    @Override
    public void writeChar(int v) throws IOException {
        log.debug("start writeChar(v) v=" + v);
        this.out.writeChar(v);
        log.debug("end writeChar(v)");
    }

    @Override
    public void writeChars(String s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeChars(s) s=" + s);
        }
        this.out.writeChars(s);
        if (log.isDebugEnabled()) {
            log.debug("end writeChars(s)");
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeDouble(v) v=" + v);
        }
        this.out.writeDouble(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeDouble(v)");
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeFloat(v) v=" + v);
        }
        this.out.writeFloat(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeFloat(v)");
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeInt(v) v=" + v);
        }
        this.out.writeInt(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeInt(v)");
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeLong(v) v=" + v);
        }
        this.out.writeLong(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeLong(v)");
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeObject(v) v=" + this.valueName(obj));
        }
        this.out.writeObject(obj);
        if (log.isDebugEnabled()) {
            log.debug("end writeObject(v)");
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeShort(v) v=" + v);
        }
        this.out.writeShort(v);
        if (log.isDebugEnabled()) {
            log.debug("end writeShort(v)");
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("start writeUTF(v) v=" + str);
        }
        this.out.writeUTF(str);
        if (log.isDebugEnabled()) {
            log.debug("end writeUTF(v)");
        }
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }
}

