/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.health.stat;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageListener;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class HealthStatEventReceiver {
    private static final Log log = LogFactory.getLog(HealthStatEventReceiver.class);
    private final HealthStatEventMessageDelegator messageDelegator;
    private final HealthStatEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private boolean terminated;
    private ExecutorService executorService;

    public HealthStatEventReceiver() {
        HealthStatEventMessageQueue messageQueue = new HealthStatEventMessageQueue();
        this.messageDelegator = new HealthStatEventMessageDelegator(messageQueue);
        this.messageListener = new HealthStatEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block3: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.HEALTH_STAT_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Health stats event message delegator thread started");
                }
                this.executorService.execute(this.messageDelegator);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Health stats receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

