/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLockHierarchy;

public class Applications
implements Serializable {
    private static Log log = LogFactory.getLog(Applications.class);
    private Map<String, Application> applicationMap = new HashMap<String, Application>();
    private boolean initialized;

    public synchronized void addApplication(Application application) {
        this.applicationMap.put(application.getUniqueIdentifier(), application);
    }

    public synchronized Application getApplication(String appId) {
        return this.getApplications().get(appId);
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public synchronized boolean applicationExists(String appId) {
        return this.getApplications().containsKey(appId);
    }

    public synchronized Map<String, Application> getApplications() {
        return this.applicationMap;
    }

    public synchronized void removeApplication(String appId) {
        this.applicationMap.remove(appId);
        ApplicationLockHierarchy.getInstance().removeLockForApplication(appId);
    }
}

