/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.mqtt;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicConnector;
import org.apache.stratos.messaging.domain.exception.MessagingException;
import org.apache.stratos.messaging.util.MessagingConstants;
import org.apache.stratos.messaging.util.MessagingUtil;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public abstract class MqttTopicConnector
implements TopicConnector {
    private static final Log log = LogFactory.getLog(MqttTopicConnector.class);
    protected MqttClient mqttClient;

    @Override
    public void connect() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connecting to message broker");
            }
            if (this.mqttClient == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"MQTT client initialization has failed previously, trying again");
                }
                this.create();
            }
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setCleanSession(true);
            this.mqttClient.connect(connectOptions);
        }
        catch (Exception e) {
            String message = "Could not connect to message broker";
            log.error((Object)message, (Throwable)e);
            throw new MessagingException(message, e);
        }
    }

    @Override
    public void create() {
        try {
            String mqttUrl = System.getProperty("mqtturl");
            if (StringUtils.isBlank((String)mqttUrl)) {
                mqttUrl = MessagingConstants.MQTT_PROPERTIES.getProperty("mqtturl", "defaultValue");
            }
            MemoryPersistence memoryPersistence = new MemoryPersistence();
            String clientId = MessagingUtil.getRandomString(23);
            this.mqttClient = new MqttClient(mqttUrl, clientId, (MqttClientPersistence)memoryPersistence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("MQTT client created: [client-id] " + clientId));
            }
        }
        catch (Exception e) {
            String message = "Could not create MQTT client";
            log.error((Object)message, (Throwable)e);
            throw new MessagingException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Disconnecting from message broker");
            }
            if (this.mqttClient == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not disconnect from message broker, MQTT client has not been initialized");
                }
                return;
            }
            MqttClient mqttClient = this.mqttClient;
            synchronized (mqttClient) {
                if (this.mqttClient.isConnected()) {
                    this.mqttClient.disconnect();
                }
                this.closeConnection();
            }
        }
        catch (Exception e) {
            String errorMsg = "Error in disconnecting from Message Broker";
            log.error((Object)errorMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing connection to message broker");
            }
            if (this.mqttClient == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not close connection, MQTT client has not been initialized");
                }
                return;
            }
            this.mqttClient.close();
        }
        catch (Exception e) {
            String message = "Could not close MQTT client";
            log.error((Object)message, (Throwable)e);
        }
        finally {
            this.mqttClient = null;
        }
    }

    @Override
    public String getServerURI() {
        if (this.mqttClient == null) {
            return null;
        }
        return this.mqttClient.getServerURI();
    }
}

