/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.ghostregistry;

import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;

public class GhostRegistry
implements Registry {
    private static Log log = LogFactory.getLog(GhostRegistry.class);
    private RegistryService registryService;
    private int tenantId;
    private RegistryType registryType;
    private Registry registry;

    public GhostRegistry(RegistryService registryService, int tenantId, RegistryType registryType) {
        this.registryService = registryService;
        this.tenantId = tenantId;
        this.registryType = registryType;
    }

    private Registry getRegistry() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        try {
            switch (this.registryType) {
                case SYSTEM_GOVERNANCE: {
                    this.registry = (Registry)this.registryService.getGovernanceSystemRegistry(this.tenantId);
                    break;
                }
                case SYSTEM_CONFIGURATION: {
                    this.registry = (Registry)this.registryService.getConfigSystemRegistry(this.tenantId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid registry type " + this.registryType);
                }
            }
        }
        catch (RegistryException e) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(e.getMessage(), e);
        }
        return this.registry;
    }

    @Override
    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getMetaData(path);
    }

    @Override
    public String importResource(String suggestedPath, String sourceURL, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().importResource(suggestedPath, sourceURL, resource);
    }

    @Override
    public String rename(String currentPath, String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().rename(currentPath, newName);
    }

    @Override
    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().move(currentPath, newPath);
    }

    @Override
    public String copy(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().copy(sourcePath, targetPath);
    }

    @Override
    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().createVersion(path);
    }

    @Override
    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getVersions(path);
    }

    @Override
    public void restoreVersion(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().restoreVersion(versionPath);
    }

    @Override
    public void addAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().addAssociation(sourcePath, targetPath, associationType);
    }

    @Override
    public void removeAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().removeAssociation(sourcePath, targetPath, associationType);
    }

    @Override
    public Association[] getAllAssociations(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getAllAssociations(resourcePath);
    }

    @Override
    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getAssociations(resourcePath, associationType);
    }

    @Override
    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().applyTag(resourcePath, tag);
    }

    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getResourcePathsWithTag(tag);
    }

    @Override
    public Tag[] getTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getTags(resourcePath);
    }

    @Override
    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().removeTag(path, tag);
    }

    @Override
    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().addComment(resourcePath, comment);
    }

    @Override
    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().editComment(commentPath, text);
    }

    @Override
    public void removeComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().removeComment(commentPath);
    }

    @Override
    public Comment[] getComments(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getComments(resourcePath);
    }

    @Override
    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().rateResource(resourcePath, rating);
    }

    @Override
    public float getAverageRating(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getAverageRating(resourcePath);
    }

    @Override
    public int getRating(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getRating(path, userName);
    }

    @Override
    public Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().executeQuery(path, parameters);
    }

    @Override
    public String[] getAvailableAspects() {
        try {
            return this.getRegistry().getAvailableAspects();
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public void associateAspect(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().associateAspect(resourcePath, aspect);
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().invokeAspect(resourcePath, aspectName, action);
    }

    @Override
    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getAspectActions(resourcePath, aspectName);
    }

    @Override
    public Collection searchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().searchContent(keywords);
    }

    @Override
    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().createLink(path, target);
    }

    @Override
    public void createLink(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().createLink(path, target, subTargetPath);
    }

    @Override
    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().removeLink(path);
    }

    @Override
    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().restore(path, reader);
    }

    @Override
    public void dump(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().dump(path, writer);
    }

    @Override
    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getEventingServiceURL(path);
    }

    @Override
    public void setEventingServiceURL(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().setEventingServiceURL(path, eventingServiceURL);
    }

    @Override
    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().newResource();
    }

    @Override
    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().newCollection();
    }

    @Override
    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().get(path);
    }

    @Override
    public Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().get(path, start, pageSize);
    }

    @Override
    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().resourceExists(path);
    }

    @Override
    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().delete(path);
    }

    @Override
    public String put(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().put(suggestedPath, resource);
    }

    public String put(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.getRegistry().put(suggestedPath, resource);
    }

    @Override
    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().beginTransaction();
    }

    @Override
    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().commitTransaction();
    }

    @Override
    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().rollbackTransaction();
    }

    public String addComment(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.getRegistry().addComment(resourcePath, comment);
    }

    public String importResource(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.getRegistry().importResource(suggestedPath, sourceURL, resource);
    }

    @Override
    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getLogs(resourcePath, action, userName, from, to, recentFirst);
    }

    @Override
    @Deprecated
    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().getLogCollection(resourcePath, action, userName, from, to, recentFirst);
    }

    @Override
    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistry().invokeAspect(resourcePath, aspectName, action, parameters);
    }

    @Override
    public boolean removeAspect(String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().removeAspect(aspect);
    }

    @Override
    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().addAspect(name, aspect);
    }

    @Override
    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistry().removeVersionHistory(path, snapshotId);
    }

    @Override
    public RegistryContext getRegistryContext() {
        try {
            return this.registry.getRegistryContext();
        }
        catch (Exception e) {
            log.error((Object)"Error getting Registry", (Throwable)e);
            return null;
        }
    }
}

