/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.impl.SimpleTarget;
import org.apache.abdera.protocol.server.servlet.ServletRequestContext;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.StringResponseContext;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.app.targets.ResourceTarget;
import org.wso2.carbon.registry.app.targets.ResponseTarget;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class RegistryResolver
implements Resolver<Target> {
    private static Log log = LogFactory.getLog(RegistryResolver.class);
    public static final TargetType TAGS_TYPE = TargetType.get((String)"tags", (boolean)true);
    public static final TargetType LOGS_TYPE = TargetType.get((String)"logs", (boolean)true);
    public static final TargetType RATINGS_TYPE = TargetType.get((String)"ratings", (boolean)true);
    public static final TargetType RENAME_TYPE = TargetType.get((String)"rename", (boolean)true);
    public static final TargetType COPY_TYPE = TargetType.get((String)"copy", (boolean)true);
    public static final TargetType MOVE_TYPE = TargetType.get((String)"move", (boolean)true);
    public static final TargetType COMMENTS_TYPE = TargetType.get((String)"comments", (boolean)true);
    public static final TargetType TAG_URL_TYPE = TargetType.get((String)"tagURL", (boolean)true);
    public static final TargetType ASSOCIATIONS_TYPE = TargetType.get((String)"associations", (boolean)true);
    public static final TargetType RESTORE_TYPE = TargetType.get((String)"restore", (boolean)true);
    public static final TargetType ASPECT_TYPE = TargetType.get((String)"aspect", (boolean)true);
    public static final TargetType VERSIONS_TYPE = TargetType.get((String)"versions", (boolean)true);
    public static final TargetType CHECKPOINT_TYPE = TargetType.get((String)"checkpoint", (boolean)true);
    public static final TargetType QUERY_TYPE = TargetType.get((String)"query", (boolean)true);
    public static final TargetType IMPORT_TYPE = TargetType.get((String)"import", (boolean)true);
    public static final TargetType DELETE_TYPE = TargetType.get((String)"delete", (boolean)true);
    public static final TargetType COLLECTION_CUSTOM_TYPE = TargetType.get((String)"col-custom", (boolean)true);
    public static final TargetType DUMP_TYPE = TargetType.get((String)"dump", (boolean)true);
    private EmbeddedRegistryService embeddedRegistryService;
    private String basePath;
    private static Map<String, TargetType> types = new HashMap<String, TargetType>();

    public RegistryResolver(EmbeddedRegistryService embeddedRegistryService, String basePath) {
        this.embeddedRegistryService = embeddedRegistryService;
        this.basePath = basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Target resolve(Request request) {
        int idx;
        RequestContext context = (RequestContext)request;
        ServletRequestContext requestContext = context instanceof ServletRequestContext ? (ServletRequestContext)request : null;
        if (this.embeddedRegistryService == null) {
            if (requestContext != null) {
                this.embeddedRegistryService = (EmbeddedRegistryService)requestContext.getRequest().getSession().getServletContext().getAttribute("registry");
            }
            if (this.embeddedRegistryService == null) {
                String msg = "Error in retrieving the embedded registry service.";
                log.error((Object)msg);
            }
        }
        UserRegistry registry = null;
        String uri = context.getUri().toString();
        String loggedIn = null;
        if (requestContext != null) {
            loggedIn = ((ServletRequestContext)request).getRequest().getParameter("loggedIn");
        }
        if (loggedIn != null) {
            String loggedUser = (String)requestContext.getRequest().getSession().getServletContext().getAttribute("logged-user");
            try {
                registry = this.embeddedRegistryService.getRegistry(loggedUser);
                uri = uri.substring(0, uri.lastIndexOf(63));
            }
            catch (RegistryException e) {
                StringResponseContext response = new StringResponseContext("Unauthorized", 401);
                response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                return new ResponseTarget(context, (ResponseContext)response);
            }
        }
        if (registry == null) {
            String authorizationString = request.getAuthorization();
            if (authorizationString != null) {
                String[] values = authorizationString.split("\\ ");
                if (values == null || values.length == 0) {
                    StringResponseContext response = new StringResponseContext("Unauthorized", 401);
                    response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                    return new ResponseTarget(context, (ResponseContext)response);
                }
                if (!"Basic".equals(values[0])) return null;
                try {
                    String userNameAlong;
                    int tenantId;
                    authorizationString = new String(Base64.decode((String)values[1]));
                    values = authorizationString.split("\\:");
                    String userName = values[0];
                    String password = values[1];
                    String tenantDomain = (String)((ServletRequestContext)request).getRequest().getAttribute("tenantDomain");
                    if (tenantDomain == null || "carbon.super".equals(tenantDomain)) {
                        tenantId = RegistryResolver.getTenantId(userName);
                        userNameAlong = RegistryResolver.getUserName(userName);
                    } else {
                        tenantId = RegistryResolver.getTenantIdFromDomain(tenantDomain);
                        userNameAlong = userName;
                    }
                    registry = this.embeddedRegistryService.getRegistry(userNameAlong, password, tenantId);
                }
                catch (Exception e) {
                    StringResponseContext response = new StringResponseContext("Unauthorized", 401);
                    response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                    return new ResponseTarget(context, (ResponseContext)response);
                }
            }
            String tenantDomain = (String)requestContext.getRequest().getAttribute("tenantDomain");
            int calledTenantId = -1234;
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                if (RegistryContext.getBaseInstance().getRealmService() == null) {
                    String msg = "Error in getting the tenant manager. The realm service is not available.";
                    log.error((Object)msg);
                    return new ResponseTarget(context, (ResponseContext)new EmptyResponseContext(400, msg));
                }
                TenantManager tenantManager = RegistryContext.getBaseInstance().getRealmService().getTenantManager();
                try {
                    calledTenantId = tenantManager.getTenantId(tenantDomain);
                }
                catch (UserStoreException e) {
                    String msg = "Error in converting tenant domain to the id for tenant domain: " + tenantDomain + ".";
                    log.error((Object)msg, (Throwable)e);
                    return new ResponseTarget(context, (ResponseContext)new EmptyResponseContext(400, msg));
                }
                try {
                    if (!tenantManager.isTenantActive(calledTenantId)) {
                        String msg = "The tenant is not active. tenant domain: " + tenantDomain + ".";
                        log.error((Object)msg);
                        return new ResponseTarget(context, (ResponseContext)new EmptyResponseContext(400, msg));
                    }
                }
                catch (UserStoreException e) {
                    String msg = "Error in converting tenant domain to the id for tenant domain: " + tenantDomain + ".";
                    log.error((Object)msg, (Throwable)e);
                    return new ResponseTarget(context, (ResponseContext)new EmptyResponseContext(400, msg));
                }
                RegistryContext.getBaseInstance().getRealmService().getBootstrapRealmConfiguration();
            }
            String anonUser = "wso2.anonymous.user";
            try {
                registry = this.embeddedRegistryService.getRegistry(anonUser, calledTenantId);
            }
            catch (RegistryException e) {
                String msg = "Error in creating the registry.";
                log.error((Object)msg, (Throwable)((Object)e));
                return new ResponseTarget(context, (ResponseContext)new EmptyResponseContext(400, msg));
            }
        }
        context.setAttribute("userRegistry", registry);
        String method = context.getMethod();
        if (uri.startsWith("/registry/registry")) {
            uri = uri.replaceFirst("/registry", "");
        }
        String[] excludeStartArr = new String[]{this.basePath + "/atom", this.basePath + "/resource", this.basePath + "/tags"};
        if (this.basePath == null) {
            log.error((Object)"Base path is null. Aborting the operation.");
            StringResponseContext response = new StringResponseContext("Internal Server Error", 500);
            return new ResponseTarget(context, (ResponseContext)response);
        }
        if (!this.basePath.equals("")) {
            for (String excludeStartStr : excludeStartArr) {
                if (uri.indexOf(excludeStartStr) <= -1 || uri.length() <= uri.indexOf(excludeStartStr) + this.basePath.length()) continue;
                uri = uri.substring(uri.indexOf(excludeStartStr) + this.basePath.length());
                break;
            }
        }
        if (!uri.startsWith("/registry")) {
            uri = uri.substring(uri.indexOf("/"));
        }
        context.setAttribute("pathInfo", (Object)uri);
        String[] parts = this.splitPath(uri);
        boolean hasColon = false;
        TargetType type = null;
        if (parts.length > 1) {
            String discriminator = parts[1];
            if (discriminator.startsWith("version:")) {
                if (parts.length > 2) {
                    if (parts[2].equals("restore")) {
                        type = RESTORE_TYPE;
                        uri = parts[0] + ";" + parts[1];
                    } else {
                        if (!parts[2].equals("associations")) return null;
                        type = ASSOCIATIONS_TYPE;
                        uri = parts[0] + ";" + parts[1];
                    }
                }
            } else {
                context.setAttribute("splitPath", (Object)parts);
                int idx2 = discriminator.indexOf(63);
                if (idx2 > -1) {
                    discriminator = discriminator.substring(0, idx2);
                }
                String suffix = null;
                idx2 = discriminator.indexOf(58);
                if (idx2 > -1) {
                    suffix = discriminator.substring(idx2 + 1, discriminator.length());
                    discriminator = discriminator.substring(0, idx2);
                    hasColon = true;
                }
                type = discriminator.startsWith("aspect") ? ASPECT_TYPE : types.get(discriminator);
                if (discriminator.equals("tag") && method.equals("DELETE") && hasColon) {
                    context.setAttribute("tagName", (Object)suffix);
                    type = DELETE_TYPE;
                } else if (discriminator.equals("comment") && method.equals("DELETE") && hasColon) {
                    context.setAttribute("commentId", (Object)suffix);
                    type = DELETE_TYPE;
                } else if (discriminator.equals("ratings") && hasColon) {
                    context.setAttribute("ratingUser", (Object)suffix);
                    type = RATINGS_TYPE;
                }
                if (type == null) {
                    return null;
                }
                if (!hasColon || !type.equals((Object)COMMENTS_TYPE) && !type.equals((Object)RATINGS_TYPE) && !type.equals((Object)TAGS_TYPE)) {
                    uri = parts[0];
                }
                if (hasColon && type.equals((Object)TAGS_TYPE)) {
                    type = null;
                }
            }
        }
        if ((idx = uri.indexOf(63)) > -1) {
            String queryString = uri.substring(idx + 1, uri.length());
            context.setAttribute("queryString", (Object)queryString);
            uri = uri.substring(0, idx);
        }
        try {
            uri = URLDecoder.decode(uri, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return null;
        }
        boolean isMedia = false;
        if (uri.startsWith("/resource")) {
            uri = uri.substring("/resource".length());
            isMedia = true;
        } else if (uri.startsWith("/atom")) {
            uri = uri.substring("/atom".length());
        } else {
            if (!uri.startsWith("/tags") || uri.length() != 5 && uri.charAt(5) != '/') return null;
            return new SimpleTarget(TAG_URL_TYPE, context);
        }
        if (uri.length() == 0) {
            uri = "/";
        }
        String startParam = context.getParameter("start");
        String pageLenParam = context.getParameter("pageLen");
        int start = startParam == null ? -1 : Integer.parseInt(startParam);
        int pageLen = pageLenParam == null ? -1 : Integer.parseInt(pageLenParam);
        Resource resource = null;
        if (type != null && type.equals((Object)DUMP_TYPE) && method != null && method.equals("POST")) {
            resource = new ResourceImpl();
            ((ResourceImpl)resource).setPath(uri);
        } else {
            CurrentSession.setUserRealm(registry.getUserRealm());
            CurrentSession.setUser(registry.getUserName());
            try {
                if (!AuthorizationUtils.authorize(RegistryUtils.getAbsolutePath(registry.getRegistryContext(), uri), "http://www.wso2.org/projects/registry/actions/get")) {
                    StringResponseContext response = new StringResponseContext("Unauthorized", 401);
                    response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                    ResponseTarget responseTarget = new ResponseTarget(context, (ResponseContext)response);
                    return responseTarget;
                }
                resource = start > -1 || pageLen > -1 ? registry.get(uri, start, pageLen) : registry.get(uri);
            }
            catch (AuthorizationFailedException e) {
                StringResponseContext response = new StringResponseContext("Unauthorized", 401);
                response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                ResponseTarget responseTarget = new ResponseTarget(context, (ResponseContext)response);
                return responseTarget;
            }
            catch (ResourceNotFoundException e) {
                if (method.equals("POST") && parts.length == 1) {
                    try {
                        Collection c = registry.newCollection();
                        registry.put(uri, c);
                        resource = registry.get(uri);
                    }
                    catch (RegistryException e1) {
                        log.error((Object)e1);
                        Target target = null;
                        return target;
                    }
                }
                if (resource == null) {
                    Target e1 = null;
                    return e1;
                }
            }
            catch (RegistryException e) {
                Target e1 = null;
                return e1;
            }
            finally {
                CurrentSession.removeUser();
                CurrentSession.removeUserRealm();
            }
            if (method.equals("GET")) {
                String currentETag;
                String ifNonMatchValue = context.getHeader("if-none-match");
                if (ifNonMatchValue != null && ifNonMatchValue.equals(currentETag = Utils.calculateEntityTag(resource))) {
                    StringResponseContext response = new StringResponseContext("Not Modified", 304);
                    return new ResponseTarget(context, (ResponseContext)response);
                }
                long ifModifiedSinceValue = 0L;
                Date ifModifiedSince = context.getDateHeader("If-Modified-Since");
                if (ifModifiedSince != null) {
                    ifModifiedSinceValue = ifModifiedSince.getTime();
                }
                if (ifModifiedSinceValue > 0L) {
                    long lastModifiedValue = resource.getLastModified().getTime();
                    if ((ifModifiedSinceValue /= 1000L) >= (lastModifiedValue /= 1000L)) {
                        StringResponseContext response = new StringResponseContext("Not Modified", 304);
                        return new ResponseTarget(context, (ResponseContext)response);
                    }
                }
            }
        }
        context.setAttribute("MyResolver", (Object)this);
        if (type != null) return new ResourceTarget(type, context, resource);
        type = method.equals("DELETE") ? DELETE_TYPE : (resource instanceof Collection ? (method.equals("HEAD") || method.equals("PUT") ? COLLECTION_CUSTOM_TYPE : TargetType.TYPE_COLLECTION) : (isMedia ? TargetType.TYPE_MEDIA : TargetType.TYPE_ENTRY));
        return new ResourceTarget(type, context, resource);
    }

    private String[] splitPath(String path) {
        return path.split("\\;");
    }

    public String getBasePath() {
        return this.basePath;
    }

    public static String getUserName(String userNameWithDomain) throws RegistryException {
        int atIndex = userNameWithDomain.indexOf(64);
        if (atIndex == -1) {
            return userNameWithDomain;
        }
        return userNameWithDomain.substring(atIndex + 1);
    }

    public static int getTenantId(String userNameWithDomain) throws RegistryException {
        int atIndex = userNameWithDomain.indexOf(64);
        if (atIndex == -1) {
            return -1234;
        }
        String domain = userNameWithDomain.substring(atIndex + 1, userNameWithDomain.length());
        return RegistryResolver.getTenantIdFromDomain(domain);
    }

    private static int getTenantIdFromDomain(String domain) throws RegistryException {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        RealmService realmService = registryContext.getRealmService();
        if (realmService == null) {
            String msg = "Error in getting the tenant manager. The realm service is not available.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        TenantManager tenantManager = realmService.getTenantManager();
        try {
            return tenantManager.getTenantId(domain);
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the tenant manager.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    static {
        types.put("tags", TAGS_TYPE);
        types.put("logs", LOGS_TYPE);
        types.put("ratings", RATINGS_TYPE);
        types.put("comments", COMMENTS_TYPE);
        types.put("rename", RENAME_TYPE);
        types.put("copy", COPY_TYPE);
        types.put("move", MOVE_TYPE);
        types.put("tagURL", TAG_URL_TYPE);
        types.put("associations", ASSOCIATIONS_TYPE);
        types.put("restore", RESTORE_TYPE);
        types.put("versions", VERSIONS_TYPE);
        types.put("checkpoint", CHECKPOINT_TYPE);
        types.put("query", QUERY_TYPE);
        types.put("application/resource-import", IMPORT_TYPE);
        types.put("dump", DUMP_TYPE);
    }
}

