/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.domain.Member;

public class Cluster {
    private static final Log log = LogFactory.getLog(Cluster.class);
    private String serviceName;
    private String clusterId;
    private Set<String> hostNames;
    private String tenantRange;
    private Map<String, Member> memberMap;
    private Map<String, String> hostNameToContextPathMap;
    private String loadBalanceAlgorithmName;

    public Cluster(String serviceName, String clusterId) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.hostNames = Collections.newSetFromMap(new ConcurrentHashMap());
        this.memberMap = new HashMap<String, Member>();
        this.hostNameToContextPathMap = new ConcurrentHashMap<String, String>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Set<String> getHostNames() {
        return this.hostNames;
    }

    public void addHostName(String hostName) {
        this.hostNames.add(hostName);
    }

    public void addHostName(String hostName, String contextPath) {
        this.hostNames.add(hostName);
        this.hostNameToContextPathMap.put(hostName, contextPath);
    }

    public void addMember(Member member) {
        this.memberMap.put(member.getMemberId(), member);
    }

    public void removeMember(String memberId) {
        Member member = this.memberMap.get(memberId);
        if (member == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Could not remove member, member not found: [member] %s", memberId));
            }
            return;
        }
        this.memberMap.remove(memberId);
    }

    public Member getMember(String memberId) {
        return this.memberMap.get(memberId);
    }

    public Collection<Member> getMembers() {
        return this.memberMap.values();
    }

    public String getTenantRange() {
        return this.tenantRange;
    }

    public void setTenantRange(String tenantRange) {
        this.tenantRange = tenantRange;
    }

    public boolean tenantIdInRange(int tenantId) {
        if (StringUtils.isEmpty((String)this.getTenantRange())) {
            return false;
        }
        if ("*".equals(this.getTenantRange())) {
            return true;
        }
        String[] array = this.getTenantRange().split("-");
        int tenantStart = Integer.parseInt(array[0]);
        if (tenantStart <= tenantId) {
            String tenantEndStr = array[1];
            if ("*".equals(tenantEndStr)) {
                return true;
            }
            int tenantEnd = Integer.parseInt(tenantEndStr);
            if (tenantId <= tenantEnd) {
                return true;
            }
        }
        return false;
    }

    public void setLoadBalanceAlgorithmName(String loadBalanceAlgorithmName) {
        this.loadBalanceAlgorithmName = loadBalanceAlgorithmName;
    }

    public String getLoadBalanceAlgorithmName() {
        return this.loadBalanceAlgorithmName;
    }

    public String getContextPath(String hostName) {
        return this.hostNameToContextPathMap.get(hostName);
    }

    public void removeHostName(String hostName) {
        this.hostNames.remove(hostName);
        this.hostNameToContextPathMap.remove(hostName);
    }
}

