/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.RemoveIndexOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class RemoveIndexRequest
extends CollectionKeyBasedRequest
implements InitializingObjectRequest {
    int index;
    int threadId;

    public RemoveIndexRequest() {
    }

    public RemoveIndexRequest(CollectionProxyId proxyId, Data key, int index, int threadId) {
        super(proxyId, key);
        this.index = index;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveIndexOperation(this.proxyId, this.key, this.threadId, this.index);
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("i", this.index);
        writer.writeInt("t", this.threadId);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.index = reader.readInt("i");
        this.threadId = reader.readInt("t");
        super.readPortable(reader);
    }
}

