/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.haproxy.extension;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HAProxyContext {
    private static final Log log = LogFactory.getLog(HAProxyContext.class);
    private static volatile HAProxyContext context;
    private String haProxyPrivateIp = System.getProperty("haproxy.private.ip");
    private String executableFilePath = System.getProperty("executable.file.path");
    private String templatePath = System.getProperty("templates.path");
    private String templateName = System.getProperty("templates.name");
    private String scriptsPath = System.getProperty("scripts.path");
    private String confFilePath = System.getProperty("conf.file.path");
    private String statsSocketFilePath = System.getProperty("stats.socket.file.path");
    private boolean cepStatsPublisherEnabled = Boolean.getBoolean("cep.stats.publisher.enabled");
    private String thriftReceiverIp = System.getProperty("thrift.receiver.ip");
    private String thriftReceiverPort = System.getProperty("thrift.receiver.port");
    private String networkPartitionId = System.getProperty("network.partition.id");
    private String clusterId = System.getProperty("cluster.id");
    private String serviceName = System.getProperty("service.name");

    private HAProxyContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("haproxy.private.ip = " + this.haProxyPrivateIp));
            log.debug((Object)("executable.file.path = " + this.executableFilePath));
            log.debug((Object)("templates.path = " + this.templatePath));
            log.debug((Object)("templates.name = " + this.templateName));
            log.debug((Object)("scripts.path = " + this.scriptsPath));
            log.debug((Object)("conf.file.path = " + this.confFilePath));
            log.debug((Object)("stats.socket.file.path = " + this.statsSocketFilePath));
            log.debug((Object)("cep.stats.publisher.enabled = " + this.cepStatsPublisherEnabled));
            log.debug((Object)("thrift.receiver.ip = " + this.thriftReceiverIp));
            log.debug((Object)("thrift.receiver.port = " + this.thriftReceiverPort));
            log.debug((Object)("network.partition.id = " + this.networkPartitionId));
            log.debug((Object)("cluster.id = " + this.clusterId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HAProxyContext getInstance() {
        if (context != null) return context;
        Class<HAProxyContext> clazz = HAProxyContext.class;
        synchronized (HAProxyContext.class) {
            if (context != null) return context;
            context = new HAProxyContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return context;
        }
    }

    public void validate() {
        this.validateSystemProperty("haproxy.private.ip");
        this.validateSystemProperty("executable.file.path");
        this.validateSystemProperty("templates.path");
        this.validateSystemProperty("templates.name");
        this.validateSystemProperty("scripts.path");
        this.validateSystemProperty("conf.file.path");
        this.validateSystemProperty("stats.socket.file.path");
        this.validateSystemProperty("cep.stats.publisher.enabled");
        this.validateSystemProperty("cluster.id");
        if (this.cepStatsPublisherEnabled) {
            this.validateSystemProperty("thrift.receiver.ip");
            this.validateSystemProperty("thrift.receiver.port");
            this.validateSystemProperty("network.partition.id");
        }
    }

    private void validateSystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (StringUtils.isEmpty((String)value)) {
            throw new RuntimeException("System property was not found: " + propertyName);
        }
    }

    public String getHAProxyPrivateIp() {
        return this.haProxyPrivateIp;
    }

    public String getExecutableFilePath() {
        return this.executableFilePath;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getScriptsPath() {
        return this.scriptsPath;
    }

    public String getConfFilePath() {
        return this.confFilePath;
    }

    public String getStatsSocketFilePath() {
        return this.statsSocketFilePath;
    }

    public boolean isCEPStatsPublisherEnabled() {
        return this.cepStatsPublisherEnabled;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

