/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client;

import javax.xml.ws.Service;
import org.apache.axis2.jaxws.BindingProvider;
import org.apache.axis2.jaxws.client.dispatch.BaseDispatch;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientUtils {
    private static Log log = LogFactory.getLog(ClientUtils.class);

    public static String findSOAPAction(MessageContext ctx) {
        OperationDescription op = ctx.getOperationDescription();
        Boolean useSoapAction = (Boolean)ctx.getProperty("javax.xml.ws.soap.http.soapaction.use");
        if (useSoapAction != null && useSoapAction.booleanValue()) {
            String action = (String)ctx.getProperty("javax.xml.ws.soap.http.soapaction.uri");
            if (action != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting soap action from JAX-WS request context.  Action [" + action + "]"));
                }
                return action;
            }
            if (op != null) {
                action = op.getAction();
                if (action != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting soap action from operation description.  Action [" + action + "]"));
                    }
                    return action;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot set the soap action.  No operation description was found.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Soap action usage was disabled");
        }
        return null;
    }

    public static boolean getExceptionToBeThrownOnSOAPFault(org.apache.axis2.context.MessageContext msgContext) {
        BindingProvider bp;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getExceptionToBeThrownOnSOAPFault(MsgContext)");
        }
        if ((bp = (BindingProvider)msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider")) == null) {
            return true;
        }
        if (bp instanceof BaseDispatch && ((BaseDispatch)bp).getMode() != Service.Mode.MESSAGE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"throwExceptionIfSOAPFault will not be checked as Dispatch is not set to Mode.MESSAGE");
                log.debug((Object)"End getExceptionToBeThrownOnSOAPFault(MsgContext)");
            }
            return true;
        }
        Object value = msgContext.getProperty("jaxws.response.throwExceptionIfSOAPFault");
        boolean throwExceptionIfSOAPFault = value != null && value instanceof Boolean ? (Boolean)value : Boolean.TRUE;
        if (log.isDebugEnabled()) {
            log.debug((Object)("throwExceptionIfSOAPFault =" + throwExceptionIfSOAPFault));
            log.debug((Object)"End getExceptionToBeThrownOnSOAPFault(MsgContext)");
        }
        return throwExceptionIfSOAPFault;
    }
}

