/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.List;
import java.util.Map;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.ConnectionCloseCode;
import org.wso2.andes.transport.ConnectionCloseOk;
import org.wso2.andes.transport.ConnectionHeartbeat;
import org.wso2.andes.transport.ConnectionOpen;
import org.wso2.andes.transport.ConnectionOpenOk;
import org.wso2.andes.transport.ConnectionRedirect;
import org.wso2.andes.transport.ConnectionSecure;
import org.wso2.andes.transport.ConnectionSecureOk;
import org.wso2.andes.transport.ConnectionStart;
import org.wso2.andes.transport.ConnectionStartOk;
import org.wso2.andes.transport.ConnectionTune;
import org.wso2.andes.transport.ConnectionTuneOk;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionInvoker {
    final void connectionStart(Map<String, Object> serverProperties, List<Object> mechanisms, List<Object> locales, Option ... _options) {
        this.invoke(new ConnectionStart(serverProperties, mechanisms, locales, _options));
    }

    final void connectionStartOk(Map<String, Object> clientProperties, String mechanism, byte[] response, String locale, Option ... _options) {
        this.invoke(new ConnectionStartOk(clientProperties, mechanism, response, locale, _options));
    }

    final void connectionSecure(byte[] challenge, Option ... _options) {
        this.invoke(new ConnectionSecure(challenge, _options));
    }

    final void connectionSecureOk(byte[] response, Option ... _options) {
        this.invoke(new ConnectionSecureOk(response, _options));
    }

    final void connectionTune(int channelMax, int maxFrameSize, int heartbeatMin, int heartbeatMax, Option ... _options) {
        this.invoke(new ConnectionTune(channelMax, maxFrameSize, heartbeatMin, heartbeatMax, _options));
    }

    final void connectionTuneOk(int channelMax, int maxFrameSize, int heartbeat, Option ... _options) {
        this.invoke(new ConnectionTuneOk(channelMax, maxFrameSize, heartbeat, _options));
    }

    final void connectionOpen(String virtualHost, List<Object> capabilities, Option ... _options) {
        this.invoke(new ConnectionOpen(virtualHost, capabilities, _options));
    }

    final void connectionOpenOk(List<Object> knownHosts, Option ... _options) {
        this.invoke(new ConnectionOpenOk(knownHosts, _options));
    }

    final void connectionRedirect(String host, List<Object> knownHosts, Option ... _options) {
        this.invoke(new ConnectionRedirect(host, knownHosts, _options));
    }

    final void connectionHeartbeat(Option ... _options) {
        this.invoke(new ConnectionHeartbeat(_options));
    }

    final void connectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        this.invoke(new ConnectionClose(replyCode, replyText, _options));
    }

    final void connectionCloseOk(Option ... _options) {
        this.invoke(new ConnectionCloseOk(_options));
    }

    protected abstract void invoke(Method var1);
}

